/***************************************************************************
                          colorprogressbar.cpp  -  description                              
                             -------------------                                         

    version              : 0.1
    begin                : Sun May 9 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@netsurf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "colorprogressbar.h"
#include <qpainter.h>
#include <qstring.h>
#include <qpixmap.h>
#include <kapp.h>

ColorProgressBar::ColorProgressBar(QWidget * parent, const char * name)
		 : 	QFrame(parent, name),
			QRangeControl(0, 100, 1, 10, 0),
			orient(Horizontal)
{
	initialize();
}

ColorProgressBar::ColorProgressBar(Orientation orientation,QWidget * parent, const char * name)
		 : 	QFrame(parent, name),
			QRangeControl(0, 100, 1, 10, 0),
			orient(orientation)
{
	initialize();
}

ColorProgressBar::ColorProgressBar(int minValue,int maxValue,int value,Orientation orientation,QWidget * parent, const char * name)
		 : 	QFrame(parent, name),
			QRangeControl(minValue, maxValue, 1, 10, value),
			orient(orientation)
{
	initialize();
	low=minValue;
	high=minValue;
}

ColorProgressBar::~ColorProgressBar(){
}

void ColorProgressBar::advance(int offset)
{
	setValue(value() + offset);
}

void ColorProgressBar::setValue(int value)
{
	QRangeControl::setValue(value);
}

void ColorProgressBar::initialize()
{
        initMetaObject();
	bar_pixmap = 0;
	bar_style = Solid;

#if QT_VERSION <200
	bar_color = kapp->selectColor;
	bar_text_color = kapp->selectTextColor;
	text_color = kapp->textColor;
	setBackgroundColor( kapp->windowColor );

#else
	bar_color = colorGroup().highlight();
	bar_text_color = colorGroup().highlightedText();
	text_color = colorGroup().text();
	setBackgroundMode( PaletteBase );
#endif
	setFont(QFont("helvetica", 12, QFont::Bold));
	text_enabled = TRUE;
	scale=0.67;
	adjustStyle();
	for (int i=0;i<3;i++) {
		color[i]=bar_color;
	}
	low=0;
	high=0;
}

/** set the color ranges from left to right */	
void ColorProgressBar::setLowRange(const QColor& c,int highValue) {
	color[0]=c;
        low=highValue;

}

void ColorProgressBar::setMidRange(const QColor& c,int highValue) {
	color[1]=c;
	high=highValue;
}

void ColorProgressBar::setHighRange(const QColor& c){
	color[2]=c;

}

void ColorProgressBar::setBarPixmap(const QPixmap &pixmap)
{
	if (pixmap.isNull())
		return;
	if (bar_pixmap)
		delete bar_pixmap;
		
	bar_pixmap = new QPixmap(pixmap);
}

void ColorProgressBar::setBarColor(const QColor &color)
{
	bar_color = color;
	if (bar_pixmap) {
		delete bar_pixmap;
		bar_pixmap = 0;
	}
}

void ColorProgressBar::setBarStyle(BarStyle style)
{
	if (bar_style != style) {
		bar_style = style;
		update();
	}
}

void ColorProgressBar::setOrientation(Orientation orientation)
{
	if (orient != orientation) {
		orient = orientation;
		update();
	}
}

void ColorProgressBar::setTextEnabled(bool enable)
{
	text_enabled = enable;
}

void ColorProgressBar::setScaleFactor(float value)
{
	scale=value;
}

int ColorProgressBar::recalcValue(int range)
{
	int abs_value = value() - minValue();
	int abs_range = maxValue() - minValue();
	return range * abs_value / abs_range;
}

void ColorProgressBar::valueChange()
{
	repaint(contentsRect(), FALSE);
	emit percentageChanged(recalcValue(100));
}

void ColorProgressBar::rangeChange()
{
	repaint(contentsRect(), FALSE);
	emit percentageChanged(recalcValue(100));
}

void ColorProgressBar::styleChange(GUIStyle)
{
	adjustStyle();
}

void ColorProgressBar::adjustStyle()
{
	switch (style()) {
		case WindowsStyle:
			setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
			break;
		case MotifStyle:
		default:
			setFrameStyle(QFrame::Panel | QFrame::Sunken);
			setLineWidth( 2 );
			break;
	}
	update();
}

void ColorProgressBar::paletteChange( const QPalette & )
{
#if QT_VERSION  < 200
	bar_color = kapp->selectColor;
	bar_text_color = kapp->selectTextColor;
	text_color = kapp->textColor;
	setBackgroundColor( kapp->windowColor );
#else
	bar_color = colorGroup().highlight();
	bar_text_color = colorGroup().highlightedText();
	text_color = colorGroup().text();
#endif
}

QSize ColorProgressBar::sizeHint() const
{
  QSize s( size() );

  if(orientation() == ColorProgressBar::Vertical) {
    s.setWidth(24);
  } else {
    s.setHeight(24);
  }

  return s;
}
		
void ColorProgressBar::drawText(QPainter *p)
{
	QRect r(contentsRect());
	QString s;
	
	s.sprintf("%i%%", recalcValue(100));
	p->setPen(text_color);
	p->drawText(r, AlignCenter, s);
	p->setClipRegion( fr );
	p->setPen(bar_text_color);
	p->drawText(r, AlignCenter, s);
	
}

void ColorProgressBar::drawContents(QPainter *p)
{
        QRect cr = contentsRect(), er = cr;
        fr = cr;
        QBrush fb(bar_color), eb(backgroundColor());
	QBrush fc1(color[0]),fc2(color[1]),fc3(color[2]);

        if (bar_pixmap)
                fb.setPixmap(*bar_pixmap);

        if (backgroundPixmap())
                eb.setPixmap(*backgroundPixmap());

        switch (bar_style) {
                case Solid:
                        if (orient == Horizontal) {
                                fr.setWidth(recalcValue(cr.width()));
                                er.setLeft(fr.right() + 1);
                        } else {
                                fr.setTop(cr.bottom() - recalcValue(cr.height()));
                                er.setBottom(fr.top() - 1);
                          }

                        p->setBrushOrigin(cr.topLeft());
                        p->fillRect(fr, fb);
                        p->fillRect(er, eb);

                        break;

                case Blocked:
                        const int margin = 2;
                        int max, num, dx, dy,lx,hx;
                        if (orient == Horizontal) {
                                fr.setHeight(cr.height() - 2 * margin);
                                fr.setWidth((int)(scale * cr.height()));
                                fr.moveTopLeft(QPoint(cr.left() + margin, cr.top() + margin));
                                dx = fr.width() + margin;
                                dy = 0;
                                max = (cr.width() - margin) / (fr.width() + margin) + 1;
                                num = recalcValue(max);
                        } else {
                                fr.setWidth(cr.width() - 2 * margin);
                                fr.setHeight((int)(scale * cr.width()));
                                fr.moveBottomLeft(QPoint(cr.left() + margin, cr.bottom() - margin));
                                dx = 0;
                                dy = - (fr.height() + margin);
                                max = (cr.height() - margin) / (fr.height() + margin) + 1;
                                num = recalcValue(max);
                        }
			lx=(low>0 ? max*low/100 : 0 );
			hx=(high>0 ? max*high/100 : 0 );
                        p->setClipRect(cr.x() + margin, cr.y() + margin,
                                                   cr.width() - margin, cr.height() - margin);
                        for (int i = 0; i < num; i++) {
                                p->setBrushOrigin(fr.topLeft());
				if (i<lx) p->fillRect(fr, fc1);
                                if ((i>=lx) && (i<hx)) p->fillRect(fr, fc2);
                                if (i>=hx) p->fillRect(fr, fc3);
                                fr.moveBy(dx, dy);
                        }

                        if (num != max) {
                                if (orient == Horizontal)
					 er.setLeft(fr.right() + 1);
                                else
                                         er.setBottom(fr.bottom() + 1);
                                if (!er.isNull()) {
                                        p->setBrushOrigin(cr.topLeft());
                                        p->fillRect(er, eb);
                                }
                        }

                        break;
        }

        if (text_enabled && bar_style != Blocked)
                drawText(p);

}








