/***************************************************************************
                          kbubblesCreateLevel.cpp  -  description
                             -------------------
    begin                : Mon Jan 10 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbubblesCreateLevel.h"
// KDE
#include <QwSpriteField.h>
#include <kapp.h>

// QT
#include <qkeycode.h>
#include <qevent.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcolor.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qfile.h>
#include <qdir.h>
#include <qcombobox.h>

// OTHER
#include "bubble.h"
#include "kbubblesMain.h"
#include "stdlib.h"
#include <iostream.h>

kbubblesCreateLevel::kbubblesCreateLevel(QWidget* parent=0, const char *name=0)
	: QWidget(parent,name)
{
	msgBox = NULL;	
	toggle_help_widget();	
	this->grabKeyboard();
	this->setFixedSize(320,448);
	QString str;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_bg_img(&str);
	
	KbField = new QwImageSpriteField(str.data(),320,448,64, 200);
		
	KbView = new QwSpriteFieldView(KbField,this);
	
	QList<QPixmap> lpm;
	QList<QPoint> lhs;

	QPixmap *pix[7];
	QPoint point(0,0);
	
	
	for (int i = 0; i < 7; i++) {
		pix[i] = new QPixmap(32,32,-1);
		this->create_pixmap(*pix[i],i);
  	pix[i]->setMask(pix[i]->createHeuristicMask());
		lpm.append(pix[i]);
		lhs.append(&point);
	}
	KbPixSeq = new QwSpritePixmapSequence(lpm,lhs);
	
  bubble = new Bubble(NULL,KbPixSeq, 6, 0, 0);
	bubble->z(10);
	bubble->bubList = new bubbleList();
	
	levelName = new QString();
  if ( ( lvls = (link_level *)malloc(sizeof(struct link_level))) == NULL)
  	exit (25);
  num_sprites = 0;
  lvls->image[0] = '\0';
  lvls->next = NULL;
  lvls->prev = NULL;
  lvls->level[0].x = -1;
}

kbubblesCreateLevel::~kbubblesCreateLevel()
{
}

void kbubblesCreateLevel::create_pixmap( QPixmap &pix, int color)
{
  char *color_name[7] = {"red", "green", "black", "white", "magenta", "grey", "yellow"};
	int dia = (pix.width() < pix.height() ? pix.width() : pix.height());
  QColor qcolor("blue");
  pix.fill(QColor::QColor( color_name[color]));
  QPainter *paint = new QPainter();
  paint->begin(&pix);
  paint->setPen(qcolor);
  paint->drawEllipse(0, 0, dia, dia);
  paint->end();
  return;
}

void kbubblesCreateLevel::move_bubble(int x, int y)
{
	static int xDist=32;
	static int yDist=28;

	int hor,ver;
	hor = bubble->x() + x * xDist + (y * xDist/2);
	ver = bubble->y() + y * yDist;	
	if ( (hor > 288) || (hor < 0) )
		return;
	if ( (ver < 5) || (ver >  368) )
		return;
	bubble->moveTo(hor,ver);
	KbField->update();
	qApp->syncX();
}

void kbubblesCreateLevel::next_color()
{
	if (++bubble->color > 6)
		bubble->color = 0;
	bubble->frame(bubble->color);
	KbField->update();
	qApp->syncX();
}

void kbubblesCreateLevel::add_sprite()
{
  int x,y;
	int i = 0;
	bubbleList *tmpList;
	tmpList = bubble->bubList;
	while ((tmpList->getNext() != NULL)) {
		tmpList = tmpList->getNext();
		if (tmpList->bub->x() == bubble->x() && tmpList->bub->y() == bubble->y()) {
			if (i != --num_sprites) {
				lvls->level[i].x = lvls->level[num_sprites].x;
				lvls->level[i].y = lvls->level[num_sprites].y;
				lvls->level[i].color = lvls->level[num_sprites].color;
			}	
			lvls->level[num_sprites].x = -1;
			tmpList = tmpList->remove();
			KbField->update();
			qApp->syncX();
			return;
		}
		i++;
	}

  x = bubble->x();
  y = bubble->y();
  if ( (x % 32) == 0) {
  	x = x / 32;
	} else {
		x = (x - 16) / 32;
	}
	y = (y - 5) / 28;
	
	Bubble *sp = new Bubble(NULL, KbPixSeq, bubble->color, x, y);
	tmpList->add(sp);	
	
	lvls->level[num_sprites].x = x;
	lvls->level[num_sprites].y = y;
	lvls->level[num_sprites].color = ( sp->color >= 6 ? -1 : sp->color + 1);
	num_sprites++;
	lvls->level[num_sprites].x = -1;

	i = 0;
	while (lvls->level[i].x != -1) {
	 	cout << lvls->level[i].x << '\t' << lvls->level[i].y << '\t' << lvls->level[i].color << '\n';
	 	i++;
	}
	KbField->update();
	qApp->syncX();
}

void kbubblesCreateLevel::load_next_frame()
{
	if (lvls->next != NULL) {
		lvls = lvls->next;
		this->reload_values();
		return;
	}
	if (lvls->level[0].x == -1)
		return;
  if ( ( lvls->next = (link_level *)malloc(sizeof(struct link_level))) == NULL)
  	exit (25);
  lvls->next->image[0] = '\0';
  lvls->next->prev = lvls;
  lvls->next->next = NULL;
  lvls->next->level[0].x = -1;
  num_sprites = 0;
  lvls = lvls->next;
	
  reload_values();
/*	
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	KbField->update();
	qApp->syncX();
*/
}

void kbubblesCreateLevel::load_prev_frame()
{
	if (lvls->prev != NULL) {
		lvls = lvls->prev;
		this->reload_values();
		return;
	}
	if (lvls->level[0].x == -1)
		return;
  if ( ( lvls->prev = (link_level *)malloc(sizeof(struct link_level))) == NULL)
  	exit (25);
  lvls->prev->image[0] = '\0';
  lvls->prev->next = lvls;
  lvls->prev->prev = NULL;
  lvls->prev->level[0].x = -1;
  num_sprites = 0;
  lvls = lvls->prev;

  reload_values();
/*
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	KbField->update();
	qApp->syncX();
*/
}
void kbubblesCreateLevel::insert_frame()
{
	if (lvls->next == NULL) {
		this->load_next_frame();
		return;
	}
	struct link_level *tmplevel;
  if ( ( tmplevel = (link_level *)malloc(sizeof(struct link_level))) == NULL)
  	exit (25);
  tmplevel->image[0] = '\0';
	tmplevel->next = lvls->next;
	tmplevel->prev = lvls;
	lvls->next->prev = tmplevel;
	lvls->next = tmplevel;
  lvls->next->level[0].x = -1;
  num_sprites = 0;
  lvls = lvls->next;

  reload_values();	
/*
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	KbField->update();
	qApp->syncX();
*/
}


void kbubblesCreateLevel::delete_frame()  	
{
	this->clear_bubbles();
	if (lvls->prev == NULL && lvls->next == NULL)
		return;
	if (lvls->prev == NULL) {
		lvls = lvls->next;
		free(lvls->prev);
		lvls->prev = NULL;
	} else if (lvls->next == NULL) {
		lvls = lvls->prev;
		free(lvls->next);
		lvls->next = NULL;
	} else {
		lvls = lvls->next;
		lvls->prev = lvls->prev->prev;
		free(lvls->prev->next);
		lvls->prev->next = lvls;
	}
	this->reload_values();
	return;	
}

void kbubblesCreateLevel::reload_values()
{
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	
	QString str;
	if (lvls->image[0] != '\0') {
		((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_level_path(&str);
		str.append(lvls->image);
		QFile f(str.data());
		if (!f.exists()) {
			str.sprintf("%s/kbubbles/%s", kapp->kde_datadir().data(), lvls->image);
			f.setName(str.data());
			if (!f.exists()) {
				((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_bg_img(&str);
			}
		}
	} else {
		((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_bg_img(&str);
	}	
	QwImageSpriteField *tempField =  new QwImageSpriteField(str.data(),320,448,64, 200);
	KbView->view(tempField);
	delete KbField;
	KbField = tempField;

  bubble = new Bubble(NULL,KbPixSeq, 6, 0, 0);
	bubble->z(10);

	
	
	num_sprites = 0;	
	while (lvls->level[num_sprites].x != -1) {
		Bubble *sp = new Bubble(NULL,KbPixSeq,
														(lvls->level[num_sprites].color < 0 ? 6 : lvls->level[num_sprites].color -1 ),
														lvls->level[num_sprites].x,lvls->level[num_sprites].y);
		tmpList = bubble->bubList;
		while ((tmpList->getNext() != NULL))
			tmpList = tmpList->getNext();
		tmpList->add(sp);	
		num_sprites++;
	}
	KbField->update();
	qApp->syncX();
}

void kbubblesCreateLevel::clear_bubbles()
{
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	KbField->update();
	qApp->syncX();

  lvls->level[0].x = -1;
  num_sprites = 0;
}

void kbubblesCreateLevel::save_levels()
{
	struct link_level *tmp;
	tmp = lvls;
	
	while (lvls->prev != NULL)
		lvls = lvls->prev;
	
	while (lvls->level[0].x == -1 && lvls->next != NULL) {  // Nothing to save
		lvls = lvls->next;
	}
  if ( lvls->level[0].x == -1 ) {
  	lvls = tmp;
  	return;
  }

	QMessageBox *msg = new QMessageBox(	i18n("Name"),"",QMessageBox::NoIcon,
																			QMessageBox::Ok | QMessageBox::Default,
																			QMessageBox::Cancel | QMessageBox::Escape,
																			0,
																		 	this->parentWidget(),"msgbox",TRUE);

	msg->setButtonText( QMessageBox::Ok, i18n("Ok") );
  msg->setButtonText( QMessageBox::Cancel, i18n("Cancel") );
	QLabel *lab = new QLabel(i18n("Name:"), msg, "label");
	lab->setAutoResize(TRUE);
	lab->move(10,15);
	lab->show();
	QLineEdit *ledit = new QLineEdit(msg, "ledit");
	ledit->setMaxLength(15);
	ledit->move(lab->x()+lab->width()+5,lab->y()-5);
	
	ledit->show();
	ledit->setFocus();
	msg->resize(10+lab->width()+5+ledit->width()+10,10+ledit->height()+50);
	while (!strcmp(ledit->text(),"")) {	
		this->releaseKeyboard();
		if (!levelName->isEmpty()) {
			ledit->setText(levelName->data());
		}
		if (msg->exec() == QMessageBox::Cancel) {
			this->grabKeyboard();
			return;
		}
		this->grabKeyboard();
	}
	levelName->setStr(ledit->text());
  int j;
  while ( (j = levelName->find('/')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('\\')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('*')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('"')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('\'')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('(')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find(')')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('&')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('$')) != -1 )
  	levelName->replace(j,1,"_");	
  while ( (j = levelName->find('!')) != -1 )
  	levelName->replace(j,1,"_");	
  if (levelName->find(".lvl",levelName->length() - 4, FALSE) == -1) {
  	levelName->append(".lvl");
  }
	QString	fname;
	((KbubblesMain *)this->parentWidget()->parentWidget())->get_level_path(&fname);
	
	cout << "levelName: " << fname.data() << levelName->data() << '\n';
	fname.append(levelName->data());
	QFile f(fname.data());
	if (!f.open(IO_WriteOnly)) {
		exit (15);
	}
	while (lvls != NULL) {
		if (lvls->level[0].x != -1 )
			f.writeBlock((char *)lvls, sizeof(struct link_level));
		lvls = lvls->next;
	}
	f.close();
	lvls = tmp;
}

void kbubblesCreateLevel::load_levels()
{
	QMessageBox *msg = new QMessageBox(	i18n("Name"),"",QMessageBox::NoIcon,
																			QMessageBox::Ok | QMessageBox::Default,
																			QMessageBox::Cancel | QMessageBox::Escape,
																			0,
																		 	this->parentWidget(),"msgbox",TRUE);
	
	msg->setButtonText( QMessageBox::Ok, i18n("Ok") );
  msg->setButtonText( QMessageBox::Cancel, i18n("Cancel") );

 	QComboBox *newLevelName = new QComboBox(FALSE,msg,"Combo");
//	newLevelName->setAutoResize(TRUE);
	newLevelName->move(5,5);
	
	QString dirpath;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_level_path(&dirpath);
  QDir dir(dirpath.data());
	QFont font;
	font.setPointSize(16);
	newLevelName->setFont(font);
	newLevelName->insertStrList( 	dir.entryList("*.lvl",
																QDir::Files | QDir::Readable | QDir::NoSymLinks,
																QDir::Name | QDir::IgnoreCase) );	
	
	
	QString datadir;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_kde_data_path(&datadir);
	dir.setPath(datadir.data());

  QStrList lst;
  lst = *dir.entryList("*.lvl",
  										QDir::Files | QDir::Readable | QDir::NoSymLinks,
  										QDir::Name | QDir::IgnoreCase );

	int i = 0;
	int found = 0;
	lst.first();
	QString tmp;
	while (lst.current() != NULL) {
		for (i = 0; i < newLevelName->count() && found == 0; i++) {
			if (!strcmp(newLevelName->text(i),lst.current()))
				found = 1;
		}
		if (found == 0) {
			newLevelName->insertItem(lst.current(), -1);
		}
		lst.next();
	}	
		
	
	msg->setFixedSize(230,100);
	
	this->releaseKeyboard();
	if ( (msg->exec()) == QMessageBox::Ok) {
		this->clear_bubbles();
		while (lvls->prev != NULL) {
			lvls = lvls->prev;
		}
		while (lvls->next != NULL) {
			lvls = lvls->next;
			free(lvls->prev);
			lvls->prev = NULL;
		}
		levelName->setStr(newLevelName->currentText());
		dirpath.append(newLevelName->currentText());
		QFile f(dirpath.data());
		if (!f.exists()) {
			datadir.append(newLevelName->currentText());
			f.setName(datadir.data());
		}
		if (!f.open(IO_ReadOnly)) {
			exit (15);
		}
		lvls->prev = lvls->next = NULL;
		while ( !f.atEnd() ) {
		  if ( ( lvls->next = (link_level *)malloc(sizeof(struct link_level))) == NULL)
  			exit (25);
			f.readBlock((char *)lvls->next, sizeof(struct link_level));
			lvls->next->next = NULL;
			lvls->next->prev = lvls;
			lvls = lvls->next;
		}
		f.close();
		while (lvls->prev != NULL)
			lvls = lvls->prev;
		lvls = lvls->next;
		free(lvls->prev);
		lvls->prev = NULL;
		this->reload_values();	
	}
	this->grabKeyboard();
}

void kbubblesCreateLevel::clear_up_and_exit()
{
	this->releaseKeyboard();
	while (bubble->bubList != NULL)
		bubble->bubList = bubble->bubList->remove();
	delete bubble;
		
	delete KbView;
	delete KbField;

	
	 	
 	while (lvls->prev != NULL)
 		lvls = lvls->prev;
 	while (lvls->next != NULL) {
 		lvls = lvls->next;
 		free(lvls->prev);
 	}
 	free(lvls);
 	emit this->done();
}

void kbubblesCreateLevel::toggle_help_widget()
{
	if (msgBox == NULL) {
		msgBox = new QWidget(NULL,"help");
		QLabel *lab = new QLabel(msgBox,"label");
		lab->setText(i18n(  "Keys:"
												"\n"
												"Arrow keys to move\n"
												"Space = Add/Remove bubble\n"
												"C = Change color\n"
												"N = Next level (add one if this is last)\n"
												"P = Previus level (add one if first)\n"
												"I = Insert new level after this\n"
												"D = Delete this level\n"
												"R = Clear all bubbles on this level\n"
												"V = Set background image\n"
												"L = Load existing level\n"
												"S = Save level\n"
												"H = Toggle this help\n"
												"B = Return to main menu\n"
												"----------\n"
												"Special colors:\n"
												"Yellow = Random\n"
												"Grey = Dead color, you can't get this\n\tcolor in the game\n"));
		lab->setAutoResize(TRUE);
		msgBox->setFixedSize(lab->width(),lab->height());
		msgBox->show();
	} else {
		msgBox->hide();
		delete msgBox;
		msgBox = NULL;
	}
	
}

void kbubblesCreateLevel::setBackgroundImg()
{
	QMessageBox *msg = new QMessageBox(	i18n("Name"),"",QMessageBox::NoIcon,
																			QMessageBox::Ok | QMessageBox::Default,
																			QMessageBox::Cancel | QMessageBox::Escape,
																			0,
																		 	this->parentWidget(),"msgbox",TRUE);
	
	msg->setButtonText( QMessageBox::Ok, i18n("Ok") );
  msg->setButtonText( QMessageBox::Cancel, i18n("Cancel") );

 	QComboBox *newImage = new QComboBox(FALSE,msg,"Combo");
	newImage->setAutoResize(TRUE);
	newImage->move(5,5);
	
	QString dirpath;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_level_path(&dirpath);
  QDir dir(dirpath.data());
	QFont font;
	font.setPointSize(16);
	newImage->setFont(font);
	newImage->insertStrList( 	dir.entryList("*.xpm",
																QDir::Files | QDir::Readable | QDir::NoSymLinks,
																QDir::Name | QDir::IgnoreCase) );	
	
	QString datadir;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_kde_data_path(&datadir);
	dir.setPath(datadir.data());

  QStrList lst;
  lst = *dir.entryList("*.xpm",
  										QDir::Files | QDir::Readable | QDir::NoSymLinks,
  										QDir::Name | QDir::IgnoreCase );

	int i = 0;
	int found = 0;
	lst.first();
	QString tmp;
	while (lst.current() != NULL) {
		for (i = 0; i < newImage->count() && found == 0; i++) {
			if (!strcmp(newImage->text(i),lst.current()))
				found = 1;
		}
		if (found == 0) {
			newImage->insertItem(lst.current(), -1);
		}
		lst.next();
	}	
	i = 0;
	while ( (i < newImage->count() - 1) &&
				( strcmp( lvls->image ,newImage->text(i) ) ) ) {
		i++;
	}

	newImage->setCurrentItem(i);			

	
	msg->setFixedSize(230,100);
	
	this->releaseKeyboard();
	if ( (msg->exec()) == QMessageBox::Ok) {
		strncpy(lvls->image,newImage->currentText(),19);
	}	
	bubbleList *tmpList;
	tmpList = bubble->bubList->getNext();
	while (tmpList != NULL)
		tmpList = tmpList->remove();
	KbField->update();
	qApp->syncX();

	/*
	QString str;
	((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_level_path(&str);
	str.append(lvls->image);
	QFile f(str.data());
	if (!f.exists()) {
		str.sprintf("%s/kbubbles/%s", kapp->kde_datadir().data(), lvls->image);
		f.setName(str.data());
		if (!f.exists()) {
			((KbubblesMain *)(this->parentWidget()->parentWidget()))->get_bg_img(&str);
		}
	}
	QwImageSpriteField *tempField =  new QwImageSpriteField(str.data(),320,448,64, 200);
	KbView->view(tempField);
	delete KbField;
	KbField = tempField;

  bubble = new Bubble(NULL,KbPixSeq, 6, 0, 0);
*/	
	this->reload_values();		
	
	this->grabKeyboard();
}

void kbubblesCreateLevel::keyReleaseEvent(QKeyEvent *key)
{
  switch (key->key()) {
  case Key_Left:
  	this->move_bubble(-1,0);
  	break;
  case Key_Right:
  	this->move_bubble(1,0);
  	break;
  case Key_Up:
  	this->move_bubble(0,-1);
  	break;
  case Key_Down:
  	this->move_bubble(0,1);
  	break;
  case Key_Space: // Save bubble in pos and make a new one
  	this->add_sprite();
  	break;
  case 'C':
  	this->next_color();
  	break;	
  case 'N': // Next, add one level if last
  	this->load_next_frame();
  	break;
  case 'P':	// Previus, insert level if at first
  	this->load_prev_frame();
  	break;
  case 'I': // Put a new frame after this one
  	this->insert_frame();
  	break;
  case 'D':	// Delete this
  	this->delete_frame();
  	break;
  case 'R': // Reset, clear bubbles
  	this->clear_bubbles();
  	break;
  case 'L':
  	this->load_levels();
  	break;
  case 'S': // Save
  	this->save_levels();
  	break;
  case 'V':
  	this->setBackgroundImg();
  	break;
  case 'H':
  	this->toggle_help_widget();
  	break;
  case 'B': // Quit
  	if (msgBox != NULL) {
  		msgBox->hide();
  		delete msgBox;
  	}
  	this->clear_up_and_exit();
  	break;
  default:
  	break;
	};
}