#ifndef _TABLE_OPTION_H_
#define _TABLE_OPTION_H_

#include <qdialog.h>
#include <qbttngrp.h>
#include <qlist.h>


class TableOption : public QDialog {
   private:
      int   _num_decks_buttons;
      int   _num_split_buttons;
      int   _num_shuffle_buttons;
      int   _btn_height;
      int   _btn_width;
      int   _pad;
      int   _shuffle_point;
      QList <int>_deck_list;
      QList <int>_split_list;
      QList <int>_shuffle_list;
      QButtonGroup *_deck_bg, *_split_bg, *_shuffle_bg;
   public:
      TableOption(int num_decks, int num_splits, int shuffle_point,
                  QWidget* parent = 0);
      int decks(void);
      int splits(void);
      int shufflePoint(void); 
      void  addDeckButton(int num);
      void  addSplitButton(int num);
      void  addShuffleButton(int num);
      void  setDecks(int num);
      void  setSplits(int num);
      void  setShufflePoint(int num);
};

#endif

