#ifndef _TABLE_INCLUDED_
#define _TABLE_INCLUDED_

#include <qwidget.h>
#include <qlist.h>
#include <qscrbar.h>
#include "hand.h"
#include "card.h"

#define TEXT_H		15
#define TEXT_W		200
#define BET_Y		130
#define VALUE_Y		(BET_Y + TEXT_H)	
#define STATUS_Y	(VALUE_Y + TEXT_H)	


class CardTable : public QWidget {
   Q_OBJECT
   private:
      int _max_hands;
      QPixmap *_pixmap_p;
      int _pixmap_dirty;
      Hand _dealer_hand;
      QList <Hand> _player_hands;
      QScrollBar *_scroll_p;
      void adjustScrollBar(void);
   public:
      CardTable(int max_hands, QWidget *parent=0, const char *name=0 );
      ~CardTable() { _player_hands.clear(); delete (_pixmap_p);}
      int  numHands(void) { return(_player_hands.count()); }
      Hand *getDealerHand(void) { return (&_dealer_hand); }
      void addPlayerHand(Hand *hp);
      Hand *getPlayerHand(int hand_num) {
           return (_player_hands.at(hand_num - 1));
      }
      void addCard(Hand *hp, Card *cp);
      Card *removeCard(Hand *hp);	// needed for a Split
      void drawHand(Hand *hp);
      void drawHands(void);
      void drawPlayerHands(void);
      void updatePlayerHands(void);
      void clear(void);

      void betText(Hand *hp);
      void statusText(Hand *hp, QString text);
   private:
      void valueText(Hand *hp);
   protected:
      void resizeEvent(QResizeEvent *re_p) { adjustScrollBar(); }
      void paintEvent(QPaintEvent *pe_p) { drawHands(); }
   private slots:
      void displayPlayerHands(int x_offset);
};

#endif

