#ifndef _STATUS_DISPLAY_INCLUDED_
#define _STATUS_DISPLAY_INCLUDED_

#include <qlabel.h>


class StatusDisplay : public QWidget {
   public:
      StatusDisplay(float bank_roll, char *help_level, QWidget *parent=0, 
                    const char *name=0 );
      void setHelp(const char *help_text);
      void setResults(float mult, float bet);	// mult: -1 = lost, 0 = push, 
						// 1 = won, 1.5 = won blackjack
      void adjustBankroll(float mult, float bet); // this is for insurnace bets
			// it does not adjust the won/lost stats
   protected:
      void resizeEvent(QResizeEvent *);
   private:
      int    _num_hands;
      float  _bank_roll;
      int    _won;
      int    _lost;
      int    _push;
      QLabel *_help_p;
      QLabel *_bank_roll_p;
      QLabel *_won_percent_p;
      QLabel *_lost_percent_p;
      QLabel *_push_percent_p;
};

#endif

