#ifndef _CARD_INCLUDED_
#define _CARD_INCLUDED_

#include <qwidget.h>
#include <qbitmap.h>

#define CARD_WIDTH   79
#define CARD_HEIGHT 123 


class Card {
   public:
      enum SuitType {SPADE, HEART, DIAMOND, CLUB};
      enum RankType {ACE = 1, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, 
                     TEN, JACK, QUEEN, KING};
      enum Direction {FACE_UP, FACE_DOWN};
   private:
      enum CardBackType {DEFAULT, USER};
      Direction _dir;
      SuitType _suit;
      RankType _rank;

      static   int      _init_flag;
      static   QBitmap *_suit_bitmaps[CLUB + 1];
      static   QBitmap *_small_suit_bitmaps[CLUB + 1];
      static   QBitmap *_large_spade_bitmap;
      static   QBitmap *_rank_bitmaps[KING + 1];
      static   QBitmap *_royalty_bitmaps[KING - JACK + 1][CLUB + 1];

      static   QPixmap *_card_pixmaps[KING + 1][CLUB + 1];
      static   QPixmap *_card_back_pixmaps[USER + 1];
   public:
      Card(RankType rank, SuitType suit, Direction dir = FACE_UP) : 
           _rank(rank), _suit(suit), _dir(dir) { }
      static void init(void);
      RankType getRank(void) { return _rank; }
      SuitType getSuit(void) { return _suit; }
      void setDirection(Direction dir) { _dir = dir; }
      QPixmap *getPixmap(void);
      QPixmap *setCardBackPixmap(QPixmap *pixmap_p) { 
              QPixmap *temp = _card_back_pixmaps[USER];
              _card_back_pixmaps[USER] = pixmap_p;
              return (temp);
      }
   private:
      QPixmap *makePixmap(void);
      static QPixmap *makeCardbackPixmap(void);
};

#endif     

