
#ifndef _BET_OPTION_H_
#define _BET_OPTION_H_

#include <qdialog.h>
#include <qbttngrp.h>
#include <qlist.h>


class BetOption : public QDialog {
   Q_OBJECT
   private:
      int   _num_bets;
      int   _num_incs;
      int   _btn_height;
      int   _btn_width;
      int   _pad;
      float _bet_min;
      float _bet_max;
      float _bet_inc;
      QList <float>_bet_list;
      QList <float>_bet_inc_list;
      QButtonGroup *_min_bg, *_max_bg, *_inc_bg;
   public:
      BetOption(float min, float max, float inc, QWidget* parent = 0);
      float min(void) { return (_bet_min); }
      float max(void) { return (_bet_max); }
      float inc(void) { return (_bet_inc); }
      void  addBet(float bet);
      void  addBetInc(float inc);
      void  setMin(float min);
      void  setMax(float max);
      void  setInc(float inc);

   private slots:
      minBetPressed(int id);
      maxBetPressed(int id);
      betIncPressed(int id);
};

#endif

