/***************************************************************************
                          Picture.cc  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Jurrien Loonstra
    email                : j.h.loonstra@st.hanze.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "Picture.h"
#include "objects.h"

#include <iostream.h>
#include <kapp.h>
#include <qstring.h>

void Picture::load(const char *name, int index) {
	QString dir = KApplication::kde_datadir(), file;
	dir += "/kbill/";
	if (index>=0)
		file.sprintf ("%spixmaps/%s_%d.xpm", (const char *)dir, name, index);
	else
		file.sprintf("%spixmaps/%s.xpm", (const char *)dir, name);
	pix = new QPixmap();
	if (pix->load(file) == FALSE)
		cerr << "cannot open " << file << endl;
	width = pix->width();
	height = pix->height();
}

QPixmap* Picture::getPixmap() {
	return pix;
}
