

/***************************************************************************
                          kyourbattlefield.cpp  -  description
                             -------------------
    begin                : Fri Oct 29 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kyourbattlefield.h"
//#include "kserverstub.h"
#include <qpainter.h>
#include <qpixmap.h>
#include <kapp.h>

#include "kmessage.h"
#include "kbattleshipview.h"
#include "kbattleshipdocbase.h"
#include "resource.h"

KYourBattleField::KYourBattleField (QWidget * parent, const char *name)
	:KBattleField (parent, name)
{
}

KYourBattleField::~KYourBattleField ()
{
}

/**  */
void KYourBattleField::cellClicked (int x, int y, int /*button*/)
{
	
	KBattleshipView * view = (KBattleshipView *) parent();
	
	if (!view->getDocBase())
		return;

  if (view->getDocBase()->cellStatus(x,y,ENEMY) != 0)
    return;

	view->getDocBase()->fire(x,y);

  repaint ();
}

/**  */
void KYourBattleField::paintShips (QPainter * p)
{
	KBattleshipView * view = (KBattleshipView *) parent();
	
	if (!view->getDocBase())
		return;
	
	  	
	p->drawText(0,0,320,10,AlignCenter,view->getDocBase()->enemyName());

	// coordinates of the cell
  int x, y, w = 10, h = 10;
  // brush to do the painting
  QBrush redBrush (red);
  QBrush blackBrush (black);
  QBrush greenBrush (green);

  QString picDir(kapp->kde_datadir() + "/kbattleship/pics/");

  QPixmap hit(picDir + "hit.xpm");
  QPixmap destroy(picDir + "destroy.xpm");

  for (int i = 0; i < 15; i++)
    {
      for (int j = 0; j < 15; j++)
			{
	  		// calculate the coordinates in pixels
			  x = (i * 20) + 10;
			  y = (j * 20) + 10;
			  switch (view->getDocBase()->cellStatus(i,j,ENEMY))
	  		  {
				    case 0:		//no status, does nothing
	
				      break;
				    case 1:		// fire, but no hit
	      			// paint a small hole in center of the cell
				      p->setBrush (blackBrush);
				      p->drawEllipse (x + 5, y + 5, w, h);
				      break;
				    case 2:		// fire and hit
				      // paint a fire
							p->drawPixmap(x,y,hit);
	
//				      p->setBrush (redBrush);
//				      p->drawEllipse (x, y, w, h);
				      break;
				    case 3:		// fire and destroyed
				      // paint a fire with a cross within
							p->drawPixmap(x,y,destroy);
	
//				      p->setBrush (greenBrush);
//				      p->drawEllipse (x, y, w, h);
				      break;
				    default:
				      break;
				    }
				}
    }
}



/**  */
void KYourBattleField::updateView()
{
 	KBattleshipView * view = (KBattleshipView *) parent();

	if (view->getDocBase()->status() == KBattleshipDocBase::FIRE)
		activate();
	else
		deactivate();
	
	if (view->getDocBase()->updatedArea() == ENEMY_AREA || view->getDocBase()->updatedArea() == ALL_AREA)
		repaint();
}
