/***************************************************************************
                          kbattleshipview.h  -  description
                             -------------------
    begin                : dom dic 12 21:31:30 CET 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBATTLESHIPVIEW_H
#define KBATTLESHIPVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

#include "kbattleshipviewbase.h"
class KBattleshipDoc;
class KBattleField;
class KBattleshipDocBase;
class QListBox;
class QLineEdit;

/** The KBattleshipView class provides the view widget for the KBattleshipApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KBattleshipView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KBattleshipApp class to manipulate and display
 * the document structure provided by the KBattleshipDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KBattleshipView : public KBattleshipViewBase
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KBattleshipView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KBattleshipView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KBattleshipApp instance as a parent
     * widget to get to the window document pointer by calling the KBattleshipApp::getDocument() method.
     *
     * @see KBattleshipApp#getDocument
     */
    KBattleshipDoc *getDocument() const;

    KBattleshipDocBase * getDocBase();

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	
  /**  */
	virtual void updateView();

private:
		KBattleField *myField, *yourField;

protected: // Protected attributes
  /**  */
  QListBox * messageList;

  /**  */
  QLineEdit * messageLine;

protected slots: // Protected slots
  /**  */
  void slotChatMessage();
protected: // Protected methods
  /**  */
  void paintEvent(QPaintEvent *);
};

#endif // KBATTLESHIPVIEW_H
