/***************************************************************************
                          kplayground.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLAYGROUND_H
#define KPLAYGROUND_H

#include "playground.h"
#include "globals.h"

#include <kapp.h>
#include <qwidget.h>
#include <qstring.h>
#include <kpixmap.h>
#include <qpainter.h>
#include <qaccel.h>
#include <qmessagebox.h>
#include <qrect.h>
#include <string.h>

/** The graphic playground
  * @author Ralf-Christian Juergensen
  */

class KPlayGround : public QWidget, public PlayGround
{
    Q_OBJECT
    	
public:
            
    KPlayGround(QWidget* parent=0, const char* name=0, Player p = ONE, QString mapFileName="1.map");
    
    ~KPlayGround(void);
    		
    int getPixWidth(void);
    int getPixHeight(void);
    		
public slots:
    
    void newGame(Player);
    void newMap(QString);
    		
    void cursorUp();
    void cursorDown();
    void cursorLeft();
    void cursorRight();
    void setCursor();
    	
signals:
    		
    void winner(Player);
    void nextRound();
    		
protected:
    	
    void paintEvent(QPaintEvent *);
    	
private:
    			
    unsigned int pixelWidth;        // width of playground in pixels
    unsigned int pixelHeight;       // height of playeground in pixels
    unsigned int fieldWidth;        // widht of a field in pixels
    unsigned int fieldHeight;       // height of a field in pixels

    KPixmap cursorOnPix;
    KPixmap cursorOffPix;
    KPixmap cursorAndPix;
    KPixmap cursorOrPix;
    KPixmap cursorXorPix;
    KPixmap cursorRndPix;
    
    KPixmap oneOnPix;
    KPixmap oneOffPix;
    KPixmap oneEmptyPix;
    KPixmap onePenguinPix;
    
    KPixmap twoOnPix;
    KPixmap twoOffPix;
    KPixmap twoEmptyPix;
    KPixmap twoPenguinPix;
    
    KPixmap noneOnPix;
    KPixmap noneOffPix;
    KPixmap noneEmptyPix;
    KPixmap nonePenguinPix;
        		
    QString currentMapFile;         // Filename of current map
    
    bool partialPaint;              // flag for how to paint the playground
    				
    void paintFields(QPainter*);
    void paintField(QPainter*, int, int);
    void paintCursor(QPainter*);
    void paintPartial(QPainter*);
    
    /** load all pixmaps needed */
    void loadPixmaps();
    /** paints a single field of a cursor. */
    void paintCursorField(QPainter* p, int x, int y, int bitNo);
};

#endif
