#include "QtDraw3D.h"

QtDraw3D::QtDraw3D (QWidget* _widget) : Draw3D()
{
	displayedBuffer=secondaryBuffer=0;

	connectToWidget (_widget);
}

QtDraw3D::~QtDraw3D()
{
	if (displayedBuffer)
		delete displayedBuffer;

	if (secondaryBuffer)
		delete secondaryBuffer;
}

void QtDraw3D::setForegroundColor (const Color& newColor)
{
	Draw3D::setForegroundColor (newColor);

	// in case painter is enabled
	painter.setPen (QColor (newColor.getR(), newColor.getG(), newColor.getB()));
}

void QtDraw3D::setBackgroundColor (const Color& newColor)
{
	Draw3D::setBackgroundColor (newColor);

	// in case painter is enabled
	painter.setBackgroundColor (QColor (newColor.getR(), newColor.getG(), newColor.getB()));
}

void QtDraw3D::saveInBuffer()
{
	*secondaryBuffer=*displayedBuffer;
}

void QtDraw3D::restoreBuffer()
{
	*displayedBuffer=*secondaryBuffer;
}

void QtDraw3D::startDrawing()
{
	painter.begin (displayedBuffer);
	painter.setPen (QColor (currentColor.getR(), currentColor.getG(), currentColor.getB()));
	painter.setBackgroundColor (QColor (backgroundColor.getR(), backgroundColor.getG(), backgroundColor.getB()));
}

void QtDraw3D::endDrawing()
{
	painter.end();
}

void QtDraw3D::updateDisplay (const int x, const int y, const int width, const int height)
{
	bitBlt (widget, x, y, displayedBuffer, x, y, width, height);
}

void QtDraw3D::clear()
{
	painter.eraseRect (0,0, width, height);
}

void QtDraw3D::connectToWidget (QWidget* _widget)
{
	widget=_widget;
	
	if (widget)
		updateSize();
}

void QtDraw3D::updateSize()
{
	width=widget->width();
	height=widget->height();

	if (displayedBuffer)
		delete displayedBuffer;
	
	if (secondaryBuffer)
		delete secondaryBuffer;

	displayedBuffer = new QPixmap (widget->size());
	secondaryBuffer = new QPixmap (widget->size());
}

void QtDraw3D::drawLine2D (const int x0, const int y0,
			   const int x1, const int y1)
{
	painter.drawLine (x0, height-y0, x1, height-y1);
}

void QtDraw3D::drawLineStrip2D()
{
	painter.moveTo (*coordinatesBuffer.xValues, height-*coordinatesBuffer.yValues);
	for (int i=1; i<coordinatesBuffer.size; i++)
	{
		coordinatesBuffer.xValues++;
		coordinatesBuffer.yValues++;
		painter.lineTo (*coordinatesBuffer.xValues, height-*coordinatesBuffer.yValues);
	}
}

void QtDraw3D::drawFilledPolygon2D()
{
	QPointArray array (coordinatesBuffer.size);
	
	int *x=coordinatesBuffer.xValues;
	int *y=coordinatesBuffer.yValues;

	for (int i=0; i<coordinatesBuffer.size; i++)
	{
		array.setPoint (i, *x, height-*y);
		x++;
		y++;
	}

	painter.setBrush (QBrush (painter.pen().color())); // fill with foreground color
	painter.drawPolygon (array);
}


// Local Variables:
// compile-command: "make QtDraw3D.o"
// End:
