#include "PerformGamePlay.h"
#include <cstdio>
#include <errno.h>
#include <cstdlib>

/** Used to remove all figures on return of program. */

class ManageFigures
{
public:
	ManageFigures() { allFigures=0; count=0; };
	~ManageFigures() { removeFigures(); };

	void setFigureArray (Figure **_allFigures, int _count) { removeFigures(); allFigures=_allFigures; count=_count; };

protected:
	void removeFigures();
	
	Figure **allFigures;
	int count;
};

void ManageFigures::removeFigures()
{
	if (allFigures)
	{
		Figure **figure=allFigures;

		for (int i=0; i<count; i++)
		{
			delete *figure;
			figure++;
		}

		delete[] allFigures;

	}
}

static ManageFigures manageFigures;


Figure **PerformGamePlay::allFigures=0;
int PerformGamePlay::countAllFigures=0;

PerformGamePlay::PerformGamePlay()
{
	points=0;
	gameEnded=false;
	obstacle=0;
	currentFigure=0;
}

PerformGamePlay::~PerformGamePlay()
{
	if (obstacle)
		delete obstacle;

	if (currentFigure)
		delete currentFigure;
}

void PerformGamePlay::draw()
{
	obstacle->draw (currentFigure);
}

void PerformGamePlay::newGame()
{
	if (currentFigure)
		delete currentFigure;
	
	obstacle->clear();
	gameEnded=false;
	points=0;

	createNewFigure();
}

void PerformGamePlay::setObstacle (Obstacle *_obstacle)
{
	obstacle=_obstacle;
}

bool PerformGamePlay::readFiguresFromFile (const char *filename)
{
	const int SIZE=256;
	char lineBuffer [SIZE];
	
	FILE *figureFile=fopen (filename, "r");
	int line=0;
	
	if (figureFile == NULL)
	{
		perror (filename);
		throw "";
	}

	line++;
	fgets (lineBuffer, SIZE, figureFile);
	
	if (sscanf (lineBuffer, "%i", &countAllFigures) != 1)
	{
		fprintf (stderr, "Error in line %i in file %s [%s]\n", line, filename, lineBuffer);
		throw "Error reading count figures";
	}
	
	allFigures = new Figure* [countAllFigures];
	Figure **allFiguresTmp=allFigures;

	manageFigures.setFigureArray (allFigures, countAllFigures);

	while (!errno && strcmp (lineBuffer, "End\n")) // fgets doesn't removes linefeed
	{
		
		line++;
		fgets (lineBuffer, SIZE, figureFile);

		int sizeX, sizeY, sizeZ;
		int r,g,b;
		if (!strcmp (lineBuffer, "End\n"))
			break;
		
		if (sscanf (lineBuffer, "%i %i %i", &sizeX, &sizeY, &sizeZ) != 3)
		{
			fprintf (stderr, "Error in line %i in file %s [%s]\n", line, filename, lineBuffer);
			throw "Error reading figure size";
		}

		line++;
		fgets (lineBuffer, SIZE, figureFile);

		if (sscanf (lineBuffer, "%i %i %i", &r, &g, &b) != 3)
		{
			fprintf (stderr, "Error in line %i in file %s [%s]\n", line, filename, lineBuffer);
			throw "Error reading figure color";
		}
		
		Figure *newFigure=new Figure (sizeX, sizeY, sizeZ);
		*allFiguresTmp=newFigure;
		allFiguresTmp++;
		while (1)
		{
			int x,y,z;
			
			line++;

			fgets (lineBuffer, SIZE, figureFile);

			if (feof (figureFile) || !strcmp (lineBuffer, "End\n") || !strcmp (lineBuffer, "EndFigure\n"))
				break;


			if (sscanf (lineBuffer, "%i %i %i", &x, &y, &z) != 3 || feof (figureFile) || errno)
			{
				fprintf (stderr, "Error in line %i in file %s [%s]\n", line, filename, lineBuffer);
				throw "Error reading figure file";
			}
			
			Color *c=new Color (r, g, b);
			newFigure->addCube (Position (x, y, z), c);
		}
	}

	int s=(allFiguresTmp-allFigures);

	if (s != countAllFigures)
	{
		fprintf (stderr, "Size differs: In first line %i and size read %i",
			 countAllFigures, s);
		throw "";
	}
	
	if (strcmp (lineBuffer,"End\n"))
	{
		fprintf (stderr, "Error in line %i in file %s [%s]\n", line, filename, lineBuffer);
		throw "Error reading from file or file truncated";
	}

	return true;
}

bool PerformGamePlay::rotateX (const int direction)
{
	Figure *fig=currentFigure->rotateX (direction);
	if (obstacle->areCollisions (*fig)
	    || !obstacle->isInsideBorder (*fig))
	{
		fig->clear (false);
		return false;
	}
	else
	{
		currentFigure->clear (false);
		delete currentFigure;
		currentFigure=fig;
		return true;
	}
}

bool PerformGamePlay::rotateY (const int direction)
{
	Figure *fig=currentFigure->rotateY (direction);
	if (obstacle->areCollisions (*fig)
	    || !obstacle->isInsideBorder (*fig))
	{
		fig->clear (false);
		return false;
	}
	else
	{
		currentFigure->clear (false);
		delete currentFigure;
		currentFigure=fig;
		return true;
	}
}

bool PerformGamePlay::rotateZ (const int direction)
{
	Figure *fig=currentFigure->rotateZ (direction);
	if (obstacle->areCollisions (*fig)
	    || !obstacle->isInsideBorder (*fig))
	{
		fig->clear (false);
		return false;
	}
	else
	{
		currentFigure->clear (false);
		delete currentFigure;
		currentFigure=fig;
		return true;
	}
}

bool PerformGamePlay::moveRel (const Position& rel)
{
	Position p=currentFigure->getOrigin();
	
	currentFigure->moveRel (rel);
	if (obstacle->areCollisions (*currentFigure)
	    || !obstacle->isInsideBorder (*currentFigure))
	{
		currentFigure->moveTo (p);
		return false;
	}

	return true;
}

int PerformGamePlay::getDelayTime() const
{
	return (8/getTimeLevel())*500;
}


bool PerformGamePlay::lowerFigureOneLevel()
{
	currentFigure->moveRel (Position (0, 0, -1));

	if (obstacle->areCollisions (*currentFigure) ||
	    currentFigure->getOrigin().getZ()==-1) // add figure to obstacle if collision or at bottom
	{
		currentFigure->moveRel ( Position (0, 0, 1) );
		points+=currentFigure->getCountOfCubes();
		obstacle->insertFigure (*currentFigure);

		delete currentFigure;
		points+=obstacle->removeLevelsWherePossible()*level;

		createNewFigure();
		if (obstacle->areCollisions (*currentFigure)) // no room for figure
			gameEnded=true;
		
		return false;
	}

	return true;
}

void PerformGamePlay::createNewFigure()
{
	int index=(int) ((float) rand()*((float) countAllFigures/(float)RAND_MAX));

	currentFigure=new Figure();
	*currentFigure=*allFigures [index];
	currentFigure->moveTo ( Position ((obstacle->getSizeX()-currentFigure->getSizeX())/2, (obstacle->getSizeX()-currentFigure->getSizeY())/2, obstacle->getSizeZ()-1)); // based on 0 inside obstacle
}

void PerformGamePlay::setTimeLevel (int _level)
{
	level=_level;
}

// Local Variables:
// compile-command: "make PerformGamePlay.o"
// End:
