/* -*- C++ -*- */

#ifndef _FIGURE_H_
#define _FIGURE_H_

#include "CubeContainer.h"


/** Manages the displaying and manipulating of figures build up of
 * cubes of the size 1,1,1.
 */
class Figure : public CubeContainer
{
public:
	/** Surrounding border. */
	Figure (const int _sizeX,
		const int _sizeY,
		const char _sizeZ);

	Figure();
	
	Figure& operator= (const Figure& _oldFigure);

	/** Copies the figure rotatet around the x-axis. direction==1 means clock
	 * wise and returns the new figure.
	 *
	 * For either this or the returned figure <b>clear(false)</b> must be
	 * called, because the cubes of this and returned figure are shared.
	 */
	Figure* rotateX (const int direction);
	Figure* rotateY (const int direction);
	Figure* rotateZ (const int direction);

	/** Moves figure to position newPos. */
	void moveTo (const Position& newPos);
	/** Moves figure relative with rel. */
	void moveRel (const Position& rel);

	/** Returns current position. */
	const Position& getOrigin() const { return origin; };

protected:
	/** The position of this figure relativ to origin of coordinate system
	 * of Draw3D::globalInstance. */
	Position origin;
};

#endif _FIGURE_H_
