/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "newtabledialog.h"
#include "newtabledialog.moc"

// --- public member functions -----------------------------------

QStrList* TNewTableDialog::strings() {
  QStrList *result = new QStrList();

  for (unsigned int i = 0; i < lbItems->count(); i++)
    result->append(lbItems->text(i));
  return result;
}

// --- private member functions ----------------------------------

// --- constructor -----------------------------------------------

TNewTableDialog::TNewTableDialog(QWidget* parent = 0, const char* name = 0,
				 bool modal = false, WFlags f = 0)
  : QDialog(parent, name, modal, f)
{
  // --- init private data ---------------------------------------  

  // --- set up window -------------------------------------------  
  setMinimumSize(260, 200);

  // --- controls ------------------------------------------------  

  leItem = new QLineEdit(this, "item_edit");
  leItem->setMinimumHeight(CONTROL_HEIGHT);
  leItem->setMaximumHeight(CONTROL_HEIGHT);
  connect(leItem, SIGNAL(returnPressed()), this, SLOT(add()) );
  
  lbItems = new QListBox(this, "lb_items");
  
  QPushButton *bAdd = new QPushButton(i18n("&Add item"),
				      this, "add_button");
  bAdd->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bAdd, SIGNAL(clicked()), this, SLOT(add()) );
  
  QPushButton *bRemove = new QPushButton(i18n("&Remove item"),
					 this, "remove_button");
  bRemove->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bRemove, SIGNAL(clicked()), this, SLOT(remove()) );
  
  QPushButton *bUp = new QPushButton(i18n("Move &up"),
				     this, "up_button");
  bUp->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bUp, SIGNAL(clicked()), this, SLOT(up()) );
  
  QPushButton *bDown = new QPushButton(i18n("Move &down"),
				       this, "down_button");
  bDown->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bDown, SIGNAL(clicked()), this, SLOT(down()) );
  
  QPushButton *bOk = new QPushButton(i18n("OK"),
				     this, "ok_button");
  bOk->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bOk, SIGNAL(clicked()), this, SLOT(ok()) );
  
  QPushButton *bCancel = new QPushButton(i18n("Cancel"),
					 this, "cancel_button");
  bCancel->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bCancel, SIGNAL(clicked()), this, SLOT(cancel()) );
  
  // --- layout --------------------------------------------------
  
  QBoxLayout *mainLayout = new QVBoxLayout(this, 6);
  QBoxLayout *topLayout = new QHBoxLayout(6);
  QBoxLayout *bottomLayout = new QHBoxLayout(10);
  QBoxLayout *leftLayout = new QVBoxLayout(2);
  QBoxLayout *rightLayout = new QVBoxLayout(4);
  
  mainLayout->addLayout(topLayout, 1);
  mainLayout->addLayout(bottomLayout);
  topLayout->addLayout(leftLayout, 1);
  topLayout->addLayout(rightLayout);

  leftLayout->addWidget(leItem);
  leftLayout->addWidget(lbItems, 1);

  rightLayout->addWidget(bAdd);
  rightLayout->addWidget(bRemove);
  rightLayout->addWidget(bUp);
  rightLayout->addWidget(bDown);
  rightLayout->addStretch(1);

  bottomLayout->addStretch(1);
  bottomLayout->addWidget(bOk);
  bottomLayout->addWidget(bCancel);
  bottomLayout->addStretch(1);
}

// --- slots -----------------------------------------------------

void TNewTableDialog::add() {
  if (*leItem->text()) {
    lbItems->insertItem(leItem->text());
    lbItems->setCurrentItem(lbItems->count() - 1);
    leItem->selectAll();
  } else
    QMessageBox::critical
      (0, APPNAME, i18n("Empty field names are not allowed."));
}
  
void TNewTableDialog::remove() {
  if (lbItems->currentItem() >= 0)
    lbItems->removeItem(lbItems->currentItem());
}

void TNewTableDialog::up() {
  int itemPos = lbItems->currentItem();

  if (itemPos > 0) {
    char *item = strdup(lbItems->text(itemPos));
    lbItems->removeItem(itemPos);
    lbItems->insertItem(item, itemPos - 1);
    lbItems->setCurrentItem(itemPos - 1);

    delete[] item;
  }
}

void TNewTableDialog::down() {
  int itemPos = lbItems->currentItem();

  if (itemPos >= 0 && (uint)itemPos < lbItems->count() - 1) {
    char *item = strdup(lbItems->text(itemPos));
    lbItems->removeItem(itemPos);
    lbItems->insertItem(item, itemPos + 1);
    lbItems->setCurrentItem(itemPos + 1);

    delete[] item;
  }
}

void TNewTableDialog::ok() {
  if (lbItems->count() > 0) {
    done(1);
  } else {
    QMessageBox::critical
      (0, APPNAME, i18n("There has to be at least one field."));
  }
}

void TNewTableDialog::cancel() {
  emit done(0);
}
