/* [nanoterm.c] minimal terminal program  */

/* Has no features (beside serial line configuration) */

/* some posix terminal handling taken from minicom. */

#include <stdio.h>
#include <stdlib.h>

#include <termios.h>
#include <fcntl.h>
#include <unistd.h>

#include <assert.h>
#include <time.h>

#define HERE fprintf(stdout,"%s(%d): here\n",__FILE__,__LINE__)

/* ---| Modem Parameters |--------------------------------------------------- */

int m_getdcd(int fd)
/* Get the data carrier detect.      */
/* i.e. tells if we are connected.   */
/* this is platform depended (sorry) */
{ unsigned int value;
  ioctl(fd, TIOCMGET, &value);
  return (value & TIOCM_CAR) ? 1 : 0;
}

/* should all be POSIX */

void m_dtrtoggle(int fd) 
/* Drop DTR line and raise it again. */
/* Used to initialize and to hangup. */
{ struct termios tty, old;
  /* Posix - set baudrate to 0 and back */
  tcgetattr(fd, &tty);
  tcgetattr(fd, &old);
  cfsetospeed(&tty, B0);
  cfsetispeed(&tty, B0);
  tcsetattr(fd, TCSANOW, &tty);
  sleep(1);
  tcsetattr(fd, TCSANOW, &old);
}

void m_setparms(int fd, char* baudr, char* par, char* bits, int hwf, int swf)
/* Set baudrate, parity and number of bits. */
{
  int spd = -1;
  int newbaud;
  int bit = bits[0];

  struct termios tty;

  tcgetattr(fd, &tty);

  /* Check if 'baudr' is really a number */
  if ((newbaud = (atol(baudr) / 100)) == 0 && baudr[0] != '0') newbaud = -1;

  switch(newbaud)
  {
    case 0:     spd = B0;      break;
    case 3:     spd = B300;    break;
    case 6:     spd = B600;    break;
    case 12:    spd = B1200;   break;
    case 24:    spd = B2400;   break;
    case 48:    spd = B4800;   break;
    case 96:    spd = B9600;   break;
    case 192:   spd = B19200;  break;
    case 384:   spd = B38400;  break;
    case 576:   spd = B57600;  break;
    case 1152:  spd = B115200; break;
  }
  
  if (spd != -1)
  {
    cfsetospeed(&tty, (speed_t)spd);
    cfsetispeed(&tty, (speed_t)spd);
  }

  switch (bit) {
   case '5':
    tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS5;
    break;
   case '6':
    tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS6;
    break;
   case '7':
    tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS7;
    break;
   case '8':
 default:
    tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS8;
    break;
  }  
  /* Set into raw, no echo mode */
  tty.c_iflag = IGNBRK;
  tty.c_lflag = 0;
  tty.c_oflag = 0;
  tty.c_cflag |= CLOCAL | CREAD;
  tty.c_cc[VMIN] = 1;
  tty.c_cc[VTIME] = 5;

  if (swf)
    tty.c_iflag |= IXON | IXOFF;
  else
    tty.c_iflag &= ~(IXON|IXOFF|IXANY);

  tty.c_cflag &= ~(PARENB | PARODD);
  if (par[0] == 'E') tty.c_cflag |= PARENB;
  if (par[0] == 'O') tty.c_cflag |= PARODD;

  if (hwf)
	tty.c_cflag |= CRTSCTS;
  else
	tty.c_cflag &= ~CRTSCTS;

  tcsetattr(fd, TCSANOW, &tty);
}

/* ---| Selective Read |----------------------------------------------------- */

int check_io(fd1, fd2, tmout, buf, buflen)
/* Check if there is IO pending. */
int fd1;
int fd2;
int tmout;
char *buf;
int *buflen;
{
  int n = 0, i;
  struct timeval tv;
  fd_set fds;

  tv.tv_sec = tmout / 1000;
  tv.tv_usec = (tmout % 1000) * 1000L;

  i = fd1;
  if (fd2 > fd1) i = fd2;

  FD_ZERO(&fds);
  if (fd1 >= 0) FD_SET(fd1, &fds); else fd1 = 0;
  if (fd2 >= 0) FD_SET(fd2, &fds); else fd2 = 0;

  if (select(i+1, &fds, NULL, NULL, &tv) > 0)
	n = 1 * (FD_ISSET(fd1, &fds) > 0) + 2 * (FD_ISSET(fd2, &fds) > 0);

  /* If there is data put it in the buffer. */
  if (buf) {
	i = 0;
	if ((n & 1) == 1) i = read(fd1, buf, 127);
	buf[i > 0 ? i : 0] = 0;
	if (buflen) *buflen = i;
  }

  return(n);
}

/* ---| Main |--------------------------------------------------------------- */

main(int argc, char* argv[])
{
  struct termios tp;
  struct termios tn;
  struct termios cp;
  struct termios cn;
  char buf[1000];
  int i,cnt,rc;
  int f;
  int pid;
  printf("nano terminal. Type ^A to abort.\n");
  /* setup modem */
  if (argc > 1)
    f = open(argv[1],O_RDWR);
  else
    f = open("/dev/modem", O_RDWR);
//f = open("/dev/ptys0", O_RDWR);
  assert( f > 0 );
  assert( 0 == tcgetattr( f, &tp ) );
  m_setparms(f, "9600", "N", "8", 1, 0);
  m_dtrtoggle(f);
  /* setup console */
  assert( 0 == tcgetattr( 0, &cp ) );
  cfmakeraw( &cn );
  assert( 0 == tcsetattr( 0, TCSANOW, &cn ) );
  /* main loop */
  printf("dcd = %d\r\n",m_getdcd(f));
  while(1)
  {
    int dcd = m_getdcd(f); int dcd_1;
    rc = check_io(f, 0, 50, buf, &cnt);
    if (rc)
    {
      if ((rc & 2) == 2)
      {
	    cnt = read(0, buf, 127);
        if (buf[0] == 1) break; /* ^A */
        for (i=0;i<cnt;i++) 
        { char c[1];
           if (buf[i] == '\n') c[0] = '\r'; else c[0] = buf[i];
          write( f, c, 1 );
        }
/*ioctl(f, TCFLSH, 2);*/
      }
      if ((rc & 1) == 1)
      {
        printf("%s",buf);
        fflush(stdout);
        dcd_1 = m_getdcd(f);
        if (dcd_1 != dcd) printf("dcd_1 = %d dcd = %d\r\n",dcd_1,dcd);
      }
    }
  }
  /* restore modem */
  assert( 0 == tcsetattr( f, TCSANOW, &tp ) );
  assert( 0 == close(f) );
  /* restore console */
  assert( 0 == tcsetattr( 0, TCSANOW, &cp ) );
  return 0;
}
