/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [zmodem.h]                ZMODEM File Transport                            */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef ZMODEM_H
#define ZMODEM_H

#include <qglobal.h>
#include <qstrlist.h>
#include <stdio.h>

#include "modem.h"

class Zmodem : public QObject
// Zmodem does the low level stream parsing and sending
// This is a purly abstact class, which in the common parent for both
// - ZmodemReceiver
// - ZmodemSender
//Fixme: clean up.
{ Q_OBJECT

  public:

    Zmodem(Modem *mo);
    ~Zmodem();
    void startReceiver(char* path, char* initial);
    void startSender(QStrList *lst);

  public:

    enum ErrorType { errorFatal, errorHeader, errorPacket };

    enum EventType { eventRcvFile, eventRcvData, eventRcvError, eventRcvDone,
                     eventSndFile, eventSndData, eventSndError, eventSndDone,
                     eventDoneProtocol
                   };

  signals:

    void event(Zmodem::EventType event, const char* text, long value);
    void doneProtocol(); //FIXME:subsume by above?

  public slots:

    void stopProtocol();

  private slots:

    void rcv_byte(int cc);

  private:
    
    void rcv_block(UINT8 type,UINT8 trailer, UINT8* info,int len);
    void rcv_error(ErrorType error);
    void rcv_cancel();

    // sending primitives ////////////////////////////////////////////////////

    void sendHexHeader(UINT8 typ, unsigned long info);
    void sendBinHeader(UINT8 typ, unsigned long info);
    void sendBinPacket(UINT8* txt, int len, UINT8 type);
    void sendBinFrame(UINT8 typ, unsigned long info, UINT8* txt, int len);
    void sendString(char* txt);

    Modem* mo;           // 

    struct ZmodemState
    {
      UINT8 state;
      UINT8 type1;
      UINT8 type2;
      bool (Zmodem::*pred)(UINT8* info, int len);
      int follow;
      UINT8 next;
      UINT8 reply;
    };
    int  state;

    int   crc;

    // receiver state ////////////////////////////////////////////////////////

    UINT8 buffer[3000];  //
    int   buftop;        // index of first free position if buffer
    int   zdlecnt;       // number of ZDLE characters in buffer
    int   hex_keep;      // keeps first hex digit value
    int   scanState;     // 
    int   scanLimit;     // maximum decoded characters expected
	int   scanCount;     // decoded characters so far
    int   incount;       // Fixme: elaborate on this.
    bool  sendingPacket; // Fixme: elaborate on this.

    void setExpect(int mode);

    // receiver state ////////////////////////////////////////////////////////

    int   last_hdr_typ;  // last header received (to assign frames to their hdrs (-1: none or error))

    // sender state /////////////////////////////////////////////////////////

    int   lastFrameType; // last header send

    int   lastFrameInfo; //FIMME: remove

    UINT8 frame_txt[1024];
    int   frame_len;

    // common file transfer state ///////////////////////////////////////////

    FILE* curr_file;
    int   curr_file_size;
    int   curr_file_offset;

    // receiver operations //////////////////////////////////////////////////

    QString downloaddict;

    void evalFileHeader(UINT8* info, int len); // code - encode
    bool pkPosOk(UINT8 *info, int len);
    bool makeFile(UINT8 *info, int len);
    bool writeBlock(UINT8 *info, int len);
    bool closeFile(UINT8 *info, int len);
    bool quit(UINT8 *info, int len);

    // sender operations ////////////////////////////////////////////////////

    QStrList file_list;

    int bytes_send; // < 0 : awaiting header // FIXME: semantic has changed!!!

    bool currFile();
    bool nextFile();
    bool zrpos(UINT8* info, int len);

  private slots:
    void clearToSend();
    void terminate();

  private:
    ZmodemState *table;
    static ZmodemState snd_table[];
    static ZmodemState rcv_table[];

};

#endif
