/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [modem.h]                     Modem Control                                */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */


#ifndef MODEM_H
#define MODEM_H

#include <qobject.h>
#include <termios.h>
#include <qsocknot.h>
#include <qtimer.h>

/* ---| Modem Parameters |--------------------------------------------------- */

class Modem: public QObject
{
Q_OBJECT

  public:
    Modem
    ( const char* device = "/dev/modem",
      long baudr   = 38400,
      char par     = 'N',
      int  bits    = 8,
      bool hwf     = TRUE, 
      bool swf     = FALSE
    );
    ~Modem();

    bool connected();
    void hangup();
    int  getdcd();      /* Get the data carrier detect.      */
    void dtrtoggle();   /* Drop DTR line and raise it again. */

//FIXME: open/close device, make a /dev/null device
    void setparms(long baudr, char par, int bits, bool hwf, bool swf);
    /* Set baudrate, parity and number of bits. */

    void send_byte(char s);
    void send_bytes(char* s, int len);
    void send_string(const char* s);

  signals:
    void chgConnect(bool);
    void data_in(int);
    void written();         // Ready to write

  private slots:
    void chk_connect();     // Get the data carrier detect.
    void DataReceived(int); //
    void DataWritten(int);  //

  private:
    int              cmdev; // shell for debugging
    int              fd;
    bool             status;
    struct termios   tp;
    QSocketNotifier* mn;
    QSocketNotifier* mw;
    QTimer*          tick;
};

#endif
