/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [ansiterm.h]            ANSI/VT100 Terminal Emulation                      */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef ANSITERM_H
#define ANSITERM_H

#include <qwidget.h>
#include <qlabel.h>
#include <qcolor.h>

#include "modem.h"

class ca
{
public:
  char   c;
  QColor f;
  QColor b;
};

class AnsiTerminal : public QWidget
/* this may hopefully become an ansi terminal emulation */
{
    Q_OBJECT
public:
    AnsiTerminal( Modem* mo, QWidget *parent=0, const char *name=0 );
    void clear();
    void home();
    void reset();
    void scroll_up();
    void scroll_down();
    void toggleCursor(bool);
    void BackSpace();
    void NewLine();
    void Return();
    void Tabulate();
    void ShowCharacter(unsigned char c);
    void ReportTerminalType();
    void ReportErrorToken();
    bool isActive() { return active; }
    bool setActive(bool flag) { active = flag; }


public slots:
    void rcv_byte(int c);

protected:
    void paintEvent( QPaintEvent * );
    bool eventFilter( QObject *, QEvent * );
    void xkeyPressEvent( QKeyEvent * );

private:
    Modem *mo;

    bool  active;

    QFont f;
    const int font_h  = 16;
    const int font_w  =  8;

    const int lines   = 25;
    const int columns = 80;
    ca image[columns][lines];

    int bmargin;
    int tmargin;

    int cu_x;
    int cu_y;
    bool cu_on;

    QColor cu_fg;
    QColor cu_bg;
    int    cu_bold;

    /* scan state II */
    unsigned char scan_buffer[100];
    int scan_buffer_pos;
    int scan_buffer_state;
    void scan_buffer_add(int c);
    void scan_buffer_init();
    void scan_buffer_report();
    void interprete(int len, unsigned char* token);
    void Interprete_1(unsigned char code);
    void Interprete_2(unsigned char code);
    void Interprete_3(int len, unsigned char token[]);

    // bulk operation
    QTimer bulk_timer;
    QRect  bulk_rect;
    bool   bulk_cu_on;
    void repaint_range(int x, int y, int h, int w, bool);

protected slots:
    void show_bulk();
};

#endif // ANSITERM_H
