/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/backend.cpp,v 1.1.1.1 1999/02/25 15:28:10 jonny Exp $

*/

#include <qstring.h>
#include <kprogress.h>
#include <iostream.h>
#include "khylafax.h"
#include "prefs.h"

#include <stdlib.h>
#include <strings.h>

int KHylaFax::sendFax(KConfig *config) {

  QString *commandline = new QString;

  commandline->append("sendfax");

  // Transmission Time
  if(strcmp(cover->transmitBut->text(),"Now") != 0) {
    commandline->append(" -a ");
    commandline->append("\"");
    commandline->append(cover->transmitBut->text());
    commandline->append("\"");
  }

  //Comments
  commandline->append(" -c ");
  commandline->append("\"");
  commandline->append(cover->memo->text());
  commandline->append("\"");

  //Email Notification
  config->setGroup("Transmission Preferences");
  if(config->readBoolEntry("Notify when Done") && config->readBoolEntry("Notify on Retry"))
    commandline->append(" -R ");
  else if(config->readBoolEntry("Notify when Done") && ! config->readBoolEntry("Notify on Retry"))
    commandline->append(" -D ");
  else if(! config->readBoolEntry("Notify when Done") && config->readBoolEntry("Notify on Retry"))
    //No commandline options allow for this
    ;
  else if(! config->readBoolEntry("Notify when Done") && ! config->readBoolEntry("Notify on Retry"))
    commandline->append(" -N ");
  
  //Sender Name
  config->setGroup("Personal Information");
  commandline->append(" -f ");
  commandline->append("\"");
  commandline->append(config->readEntry("Name"));
  commandline->append("\"");
  
  //Fax Server Machine
  //commandline->append(" -h ");
  //commandline->append(config->readEntry("Hostname"));

  //DPI
  config->setGroup("Transmission Preferences");
  if(config->readNumEntry("Dpi") == 98)
    commandline->append(" -l ");
  else
    commandline->append(" -m ");

  //Cover Page Send?
  config->setGroup("Transmission Preferences");
  if(! config->readBoolEntry("Send Coverpage"))
    commandline->append( " -n ");

  //Subject
  commandline->append(" -r ");
  commandline->append("\"");
  commandline->append(cover->subject->text());
  commandline->append("\"");

  //Retries
  config->setGroup("Transmission Preferences");
  commandline->append(" -t ");
  commandline->append(config->readEntry("Maximum Retries"));

  //Company
  commandline->append(" -x ");
  commandline->append("\"");
  commandline->append(cover->company->text());
  commandline->append("\"");

  //Location
  commandline->append(" -y ");
  commandline->append("\"");
  commandline->append(cover->location->text());
  commandline->append("\"");

  //Fax Phone Dest
  commandline->append(" -d ");
  commandline->append("\"");
  commandline->append(cover->rcpt->text());
  commandline->append("@");
  commandline->append(cover->faxNum->text());
  commandline->append("\"");

  // start a new job
  cout << netcom->command("JNEW");

  cout << netcom->command("JPARM FROMUSER jonny") << endl;
  cout << netcom->command("JPARM LASTTIME 000259") << endl;

  QString jobname;

  // set fax number
  cout << netcom->command(QString("JPARM DIALSTRING ") + QString(cover->faxNum->text()));
  cout << netcom->command(QString("JPARM SENDTIME NOW")) << endl;

  //Fax Files
  for(uint i= 0; i < fileList->count(); i++) {
    commandline->append(" ");
    commandline->append(fileList->text(i));

    cout << "send file " << fileList->text(i) << endl;

    QBuffer *buffer = new QBuffer();
    buffer->open(IO_ReadWrite);

    FILE *fd = fopen(fileList->text(i), "r");
    if(fd==0)
    {
    	cout << "cant open file " << fileList->text(i) << endl;
    }

    int numread;
    char buf[1024];

    while((numread = fread(buf, 1, sizeof(buf), fd)) > 0)
    {
	buffer->writeBlock(buf, numread);
	cout << "sending " << numread << " bytes to server..." << endl;
    }

    fclose(fd);

    jobname = netcom->sendBuffer(buffer);
  }

  cout << netcom->command(QString("JPARM DOCUMENT ") + jobname) << endl;

  cout << netcom->command("JSUBM") << endl;
  
//  system(commandline->data());

  return 0;
}

/*

$Log: backend.cpp,v $
Revision 1.1.1.1  1999/02/25 15:28:10  jonny


Revision 1.2  1998/07/22 13:22:59  jlublin
initial revision


*/









