/***************************************************************************
                          calleditdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Jul 14 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "calleditdlg.h"
//#include "dhlog.h"

CallEditDlg::CallEditDlg(QWidget *parent, const char *aname) : QDialog(parent,aname,true){
	initDialog();
	
	callLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	name->setMaxLength(20);
	qth->setMaxLength(20);
	dok->setMaxLength(6);
	locator->setMaxLength(6);
	
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotOk()));
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	
}

void CallEditDlg::SetCallRef(CCall *acall)
{
	char help[15];
	
	call = acall;
	call->GetCall(help);
	callLabel->setText(help);
	name->setText(call->GetName());
	qth->setText(call->GetQth());
	dok->setText(call->GetDok());
	locator->setText(call->GetLocator());
	
	name->setFocus();
}

void CallEditDlg::callChecked(int result)
{
	switch(result)
	{
		case CALLCHECK_NAME:
			name->setFocus();
			break;
		case CALLCHECK_QTH:
			qth->setFocus();
			break;
		case CALLCHECK_DOK:
			dok->setFocus();
			break;
		case CALLCHECK_LOC:
			locator->setFocus();
			break;
	}
}


CallEditDlg::~CallEditDlg(){
}

//
// Signale abhandeln
//...................

void CallEditDlg::slotOk()
{
	QString help;
	char ic,test[7];
	
	ic = 0;
	
	help = locator->text();	
	strcpy(test,help);
	if(isalpha(test[0])) ic++;
	if(isalpha(test[1])) ic++;
	if(isdigit(test[2])) ic++;
	if(isdigit(test[3])) ic++;
	if(isalpha(test[4])) ic++;
	if(isalpha(test[5])) ic++;
	if(strlen(test) == 0)
	{
		ic = 6;
		help = "------";
	}
	if(strcmp(test,"------") == 0) ic = 6;
	
	if(ic != 6)
	{
		KMsgBox::message(this,i18n("Edit Call"),i18n("Unknown Locator.\nUse 6 digits like JO41EB or none.\n"));
		locator->setFocus();
		return;
	}
	call->SetLocator(help.upper());
	call->SetName(name->text());
	call->SetQth(qth->text());
	help = dok->text();
	call->SetDok(help.upper());
	done(true);
}








