/***************************************************************************
                          modeline.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Thu Feb 11 1999                                           
    copyright            : (C) 1999 by Didier Gaudin                         
    email                : gaudin@club-internet?fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>

#include "modeline.h"
#include <qfont.h>
#include <kconfig.h>
#include <qstrlist.h>

Modeline::Modeline(QWidget *parent, const char *name) : QWidget(parent, name)
{
  QString tmp;
  QString l;
   modified=FALSE;
  line = new  QMultiLineEdit(this);
  line -> setFont( QFont( "times",12 ,QFont::Bold , FALSE) );
  line -> setGeometry(5,5,425,370);

  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  QStrList  ListeMode ;
  fichier -> setGroup("Modeline");
  if( fichier -> readNumEntry("NbLine") >0 )
  {
   for (int n=0 ; n<fichier ->readNumEntry("NbLine"); n++)
   {
     tmp.sprintf("Line%d",n);
     l=fichier->readEntry(tmp.data());
     line->insertLine(l );
   }
  }
  else
    init_valeur();

  connect(line, SIGNAL(textChanged()), SLOT(slottextchanged()));
}

void Modeline::init_valeur()
{
  modified=TRUE;
  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   640x480\t\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 640x480 @ 60 Hz, 31.5 kHz hsync");
  line -> setFont( QFont( "times",12 ,QFont::Normal , TRUE) );
  line -> insertLine("Modeline \"640x480\"     25.175 640  664  760  800   480  491  493  525\n");
  line -> insertLine("# 640x480 @ 72 Hz, 36.5 kHz hsync");
  line -> insertLine("Modeline \"640x480\"     31.5   640  680  720  864   480  488  491  521\n");
  line -> insertLine("# 640x480 @ 75 Hz, 37.50 kHz hsync ");
  line -> insertLine("ModeLine  \"640x480\"    31.5   640  656  720  840   480  481  484  500 -HSync -VSync\n");
  line -> insertLine("# 640x480 @ 85 Hz, 43.27 kHz hsync");
  line -> insertLine("Modeline \"640x400\"     36     640  696  752  832   480  481  484  509 -HSync -VSync\n");
  line -> insertLine("# 640x480 @ 100 Hz, 53.01 kHz hsync");
  line -> insertLine("Modeline \"640x480\"     45.8   640  672  768  864   480  488  494  530 -HSync -VSync\n");
  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   800x600\t\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 800x600 @ 56 Hz, 35.15 kHz hsync");
  line -> insertLine("ModeLine \"800x600\"     36     800  824  896 1024   600  601  603  625\n");
  line -> insertLine("# 800x600 @ 60 Hz, 37.8 kHz hsync ");
  line -> insertLine("Modeline \"800x600\"     40     800  840  968 1056   600  601  605  628 +hsync +vsync\n");
  line -> insertLine("# 800x600 @ 72 Hz, 48.0 kHz hsync");
  line -> insertLine("Modeline \"800x600\"     50     800  856  976 1040   600  637  643  666 +hsync +vsync\n");
  line -> insertLine("# 800x600 @ 85 Hz, 55.84 kHz hsync ");
  line -> insertLine("Modeline  \"800x600\"    60.75  800  864  928 1088   600  616  621  657 -HSync -VSync\n");
  line -> insertLine("# 800x600 @ 100 Hz, 64.02 kHz hsync");
  line -> insertLine("Modeline  \"800x600\"    69.65  800  864  928 1088   600  604  610  640 -HSync -VSync");

  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   1024x768\t\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 1024x768 @ 87 Hz interlaced, 35.5 kHz hsync");
  line -> insertLine("Modeline \"1024x768\"    44.9  1024 1048 1208 1264   768  776  784  817 Interlace\n");
  line -> insertLine("# 1024x768 @ 60 Hz, 48.4 kHz hsync ");
  line -> insertLine("Modeline \"1024x768\"    65    1024 1032 1176 1344   768  771  777  806 -hsync -vsync\n");
  line -> insertLine("# 1024x768 @ 70 Hz, 56.5 kHz hsync");
  line -> insertLine("Modeline \"1024x768\"    75    1024 1048 1184 1328   768  771  777  806 -hsync -vsync\n");
  line -> insertLine("# 1024x768 @ 76 Hz, 62.5 kHz hsync");
  line -> insertLine("Modeline \"1024x768\"    85    1024 1032 1152 1360   768  784  787  823\n");
  line -> insertLine("# 1024x768 @ 85 Hz, 70.24 kHz hsync");
  line -> insertLine("Modeline \"1024x768\"   98.9  1024 1056 1216 1408   768 782 788 822 -HSync -VSync\n");
  line -> insertLine("# 1024x768 @ 100Hz, 80.21 kHz hsync");
  line -> insertLine("Modeline \"1024x768\"   115.5  1024 1056 1248 1440  768  771  781  802 -HSync -VSync\n");


  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   1125x864\t\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 1152x864 @ 89 Hz interlaced, 44 kHz hsync");
  line -> insertLine("ModeLine \"1152x864\"    65    1152 1168 1384 1480   864  865  875  985 Interlace\n");
  line -> insertLine("# 1152x864 @ 60 Hz, 53.5 kHz hsync ");
  line -> insertLine("Modeline  \"1152x864\"   89.9  1152 1216 1472 1680   864  868  876  892 -HSync -VSync\n");
  line -> insertLine("# 1152x864 @ 70 Hz, 62.4 kHz hsync");
  line -> insertLine("Modeline  \"1152x864\"   92    1152 1208 1368 1474   864  865  875  895\n");
  line -> insertLine("# 1152x864 @ 78 Hz, 70.8 kHz hsync");
  line -> insertLine("Modeline \"1152x864\"   110   1152 1240 1324 1552   864  864  876  908\n");
  line -> insertLine("# 1152x864 @ 84 Hz, 76.0 kHz hsync");
  line -> insertLine("Modeline \"1152x864\"   135    1152 1464 1592 1776   864  864  876  908\n");
  line -> insertLine("# 1152x864 @ 100 Hz, 89.62 kHz hsync");
  line -> insertLine("Modeline \"1152x864\"   137.65 1152 1184 1312 1536   864  866  885  902 -HSync -VSync\n");


  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   1280x1024\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 1280x1024 @ 87 Hz interlaced, 51 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"   80    1280 1296 1512 1568  1024 1025 1037 1165 Interlace\n");
  line -> insertLine("# 1280x1024 @ 61 Hz, 64.2 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  110    1280 1328 1512 1712  1024 1025 1028 1054\n");
  line -> insertLine("# 1280x1024 @ 70 Hz, 74.59 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  126.5 1280 1312 1472 1696  1024 1032 1040 1068 -HSync -VSync\n");
  line -> insertLine("# 1280x1024 @ 74 Hz, 78.85 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  135    1280 1312 1456 1712  1024 1027 1030 1064\n");
  line -> insertLine("# 1280x1024 @ 76 Hz, 81.13 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  135    1280 1312 1416 1664  1024 1027 1030 1064\n");
  line -> insertLine("# 1280x1024 @ 85 Hz, 91.15 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  157.5  1280 1344 1504 1728  1024 1025 1028 1072 +HSync +VSync\n");
  line -> insertLine("# 1280x1024 @ 100 Hz, 107.16 kHz hsync");
  line -> insertLine("Modeline \"1280x1024\"  181.75 1280 1312 1440 1696  1024 1031 1046 1072 -HSync -VSync\n");

  line -> insertLine("##########################################################");
  line -> insertLine("#                 RESOLUTION   1600x1200\t\t\t#");
  line -> insertLine("##########################################################");
  line -> insertLine("# 1600x1200 @ 60Hz, 75.00 kHz hsync");
  line -> insertLine("Modeline \"1600x1200\"  162   1600 1664 1856 2160  1200 1201 1204 1250 +HSync +VSync\n");
  line -> insertLine("# 1600x1200 @ 70 Hz, 87.50 kHz hsync");
  line -> insertLine("Modeline \"1600x1200\"  189    1600 1664 1856 2160  1200 1201 1204 1250 -HSync -VSync\n");
  line -> insertLine("# 1600x1200 @ 75 Hz, 93.75 kHz hsync");
  line -> insertLine("Modeline \"1600x1200\"  202.5  1600 1664 1856 2160  1200 1201 1204 1250 +HSync +VSync\n");
  line -> insertLine("# 1600x1200 @ 85 Hz, 105.77 kHz hsync");
  line -> insertLine("Modeline \"1600x1200\"  220    1600 1616 1808 2080  1200 1204 1207 1244 +HSync +VSync\n");
}



Modeline::~Modeline(){
}


void Modeline::writeconfig()
{
  if(modified==TRUE)
  {
   QString tmp;
   KConfig * fichier = new KConfig(NULL, "xfreeconfig");
   fichier -> setGroup("Modeline");
   fichier -> writeEntry("NbLine",line->numLines());
   for ( int n = 0; n < line->numLines() ; n++)
   {
      tmp.sprintf("Line%d",n);
      fichier->writeEntry(tmp.data(),line->textLine(n));
   }
   fichier->sync();
   delete fichier; // delete fichier;
   modified=FALSE;
  }
}

void Modeline::slottextchanged()
{
  modified=TRUE;
}









