/***************************************************************************
    $Id: apsfilterconfig.h,v 1.1 1999/09/14 00:26:24 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: apsfilterconfig.h,v $
    Revision 1.1  1999/09/14 00:26:24  wdl
    Restructuring of directories

    Revision 1.3  1999/09/09 06:01:57  stephan
    Added OO style spool handling (by using KpcSpool)

    Revision 1.2  1999/08/27 16:43:01  wdl
    Standard Headers

 ***************************************************************************/
#ifndef APSFILTERCONFIG_H
#define APSFILTERCONFIG_H

#include <qstring.h>
/**
  *@author Stephan Heigl
  */

class apsfilterConfig {
public: 
	apsfilterConfig();
	apsfilterConfig(apsfilterConfig &to_cp);
	~apsfilterConfig();

  void setFilterDir(const char *val) { FilterDir = val; }
	void setTypeRecognition(const char *val) { TypeRecognition = val; }
	void setGSDriver(const char *val) { GSDriver = val; }
	void setPaperSize(const char *val) {PaperSize = val; PaperSize.lower();}
	void setResolution(const char *val) { Resolution = val; }
	void setGSoptions(const char *val) { GSoptions = val; }
	void setEnableColor(bool val) { EnableColor = val; }

	const char *getFilterDir() { return FilterDir.data(); }
	const char *getTypeRecognition() { return TypeRecognition.data(); }
	const char *getGSDriver() { return GSDriver.data(); }
	const char *getPaperSize()  { return PaperSize.data(); }
	const char *getResolution() { return Resolution.data(); }
	const char *getGSoptions() { return GSoptions.data(); }

	bool isEnableColor() { return EnableColor; }

private:
	QString FilterDir;
	QString TypeRecognition;
	QString GSDriver;
	QString PaperSize;
	QString Resolution;
	QString GSoptions;
	bool EnableColor;		
};

#endif






