/***************************************************************************
                          page4.h  -  Header of page4.cpp
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PAGE4_H
#define PAGE4_H

#include <kinstall.h>
#include "medit.h"

/**
  *@author Hugo Santos
  */

class Page4 : public _Page  {
   Q_OBJECT
public: 
	Page4(_KInstall *parent=0, const char *name=0);
	~Page4();
private slots:
	void slotFinished();
	void slotAbortAll();
	void slotBeginAll();
	void slotBeginCVSDist();
	void slotBeginConf();
	void slotBeginMake();
	void slotBeginInst();
	void slotShowMeErrorReport();
	void slotEndedConf();
	void slotEndedMake();
	void slotEndedInst();
	void slotEndedCVSDist();
	void slotErrorFound( KProcess *,char *buffer, int buflen );
	void slotEditMakefile();
private:
	KShellProcess *q;
	QLabel *p_conf;
	QLabel *p_make;
	QLabel *p_inst;
	QLabel *p_plwa;	
	QLineEdit *p_out;
	bool foundErrOrNotFound;
	bool alreadyErrShown;
	bool editedMakefile;
	const char * lastError;
	KMsgBox *mb;
	MEdit *ed;
protected:
	void resizeEvent( QResizeEvent * );
signals:
	void errorFound();
	void finishedAll();
};

#endif