/************************************************************************
 * kcreateinst - part of kinst package - preferences.h                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _PREFERENCES_H
#define _PREFERENCES_H

#include "tparams.h"

#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <kfiledialog.h>
#include <drag.h>

class kcreateinstPreferences:public QDialog
{
  Q_OBJECT
 private:
  tParams* origparams;
  tParams* newparams;
  KFileDialog* FileSelector;
  QLineEdit* kipackpath_edit;
  QLineEdit* selfextractpath_edit;
  QLineEdit* kinstpath_edit;
  QLineEdit* kinstlocalepath_edit;
  QLineEdit* scriptpath_edit;
  QLabel* kipackpath_label;
  QLabel* selfextractpath_label;
  QLabel* kinstpath_label;
  QLabel* kinstlocalepath_label;
  QLabel* scriptpath_label;
  QPushButton* ok_button;
  QPushButton* cancel_button;
  QPushButton* help_button;
  QPushButton* kipackpath_button;
  QPushButton* selfextractpath_button;
  QPushButton* kinstpath_button;
  QPushButton* kinstlocalepath_button;
  QPushButton* scriptpath_button;
 private slots:
  void Browse1Pressed();
  void Browse2Pressed();
  void Browse3Pressed();
  void Browse4Pressed();
  void Browse5Pressed();
  void ok_pressed();
  void cancel_pressed();
  void help_pressed();
 protected:
  void resizeEvent(QResizeEvent*);
 public:
  void getPrefs(tParams* actprefs);
  kcreateinstPreferences(QWidget *parent, const char *name);
};

#endif

