/************************************************************************
 * kinst - KDE Application Installer - gui.h                            *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _GUI_H
#define _GUI_H

#include <qwidget.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <kprogress.h>
#include <kfiledialog.h>
#include <kfm.h>

#include "locale.h"
#include "install.h"
#include "readfile.h"
#include "kdeconfig.h"
#include "scriptrun.h"
#include "libraries.h"
#include "kiss.h"
#include "kmenutree.h"

class tYesNoDlg:public QDialog
{
  Q_OBJECT
 private:
  int i;
  QString text;
  QLabel* text_label;
  QPushButton* yes_button;
  QPushButton* no_button;
  QPixmap* BooksImage;
  QLabel* BooksImage_Label;
 private slots:
  void YesPressed();
  void NoPressed();
 protected:
  void resizeEvent(QResizeEvent*);
 public:
  int getYesNo(QString text_to_display);
  tYesNoDlg(QWidget* parent, const char* name);
};

class kinstMainWidget:public KTopLevelWidget
{
  Q_OBJECT
private:
  char _KIF_Source_Directory[FILENAME_MAX];
  int StepNr;
  // Main screen
  // -----------
  QPixmap* SetupPicture;
  QLabel* SetupPictureLabel;
  QPushButton* NextButton;
  QPushButton* PreviousButton;
  QPushButton* ExitButton;
  QPushButton* AboutButton;
  QFrame* Separation;
  QFrame* Frame;
  QLabel* TitleLabel;
  QLabel* InfoLabel;
  QLabel* DestFolderLabel;
  QLabel* DestGroupLabel;
  QLineEdit* DestFolderLineEdit;
  QLineEdit* DestGroupLineEdit;
  QPushButton* DestFolderButton;
  QPushButton* DestGroupButton;
  KDirDialog* DestFolderDialog;
  QMultiLineEdit* MultiLineEdit;
  QPushButton* URLViewButton;
  QCheckBox* Install1_check;
  QCheckBox* Install2_check;
  QCheckBox* Install3_check;
  QCheckBox* Install4_check;
  QCheckBox* Install5_check;
  QCheckBox* Install6_check;
  QString DestDir;
  QString DestGroup;
  QRect* r;
  KProgress* ProgressBar;
  tKIFReader* KIFReader;
  tKIFInstall* KIFInstall;
  tKDEConfig* KDEConfig;
  tScriptRun* ScriptRun;
  tInstSharedLibraries *SharedLibs;
  KFM* filemanager;
  tYesNoDlg* YesNoDlg;
  tKISS* KISS;
  tKMenuTreeDlg* KMenuTreeDlg;

  void newContent(int nr);

private slots:
  void PreviousPressed(void);
  void NextPressed(void);
  void AboutPressed(void);
  void DestFolderButtonPressed(void);
  void DestGroupButtonPressed(void);
  void OpenTheURL();
  int StartInstallation(void);

protected:
  void closeEvent(QCloseEvent *e);
  void resizeEvent(QResizeEvent*);

public:
  kinstMainWidget();
  int kinstMainWidgetKIFinit(char *infofilename);
};

#endif
