/***************************************************************************
                          khtab2.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHTAB2_H
#define KHTAB2_H

#include <kapp.h>
#include "khglobals.h"
#include <qwidget.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcombobox.h>

struct KHTab2Private{
	QBoxLayout *toplayout;
	QBoxLayout *notifylayout;
	QBoxLayout *shutdownlayout;
	QBoxLayout *dockinglayout;
	QBoxLayout *hbox;
	QGroupBox *group;
	QButtonGroup *bg;
	QLabel *l;
	QRadioButton *rb;	
	QComboBox *cb;
	QSpinBox *s;
};

/**This class provides a spin box by which the user can choose the
	*interval in which alarm messages pop up.
  *@author Ruediger Anlauf
	*@short tab 2 of the configuration dialog
  */

class KHTab2 : public QWidget  {

Q_OBJECT

public:
	/** constructor */
	KHTab2( QWidget *parent = 0, const char* name = 0 );

	/** destructor */
	~KHTab2();

protected:
	/** a pointer to the application's config object */
	KConfig *config;
	KHTab2Private *d;
	
protected slots:
	/** writes the value from QSpinNI to the app's config object */
	void writeNotificationInterval( int value );

	/** writes the value from QSpinRI to the app's config object */
	void writeReactionTime( int value );

	void writeShutdownEnabled( int value );
	
	void writeShutdownNotification( int value );

	void writeDockingEnabled( int value );

	void writeDisplayDocking( int item );
};


#endif
































