/***************************************************************************
                          khtab1.h  -  description
                             -------------------                                         
    begin                : Mon Aug 2 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CONFIGDLG_H
#define CONFIGDLG_H

#include <qwidget.h>
#include "khglobals.h"
#include "khconfigitem.h"

class KConfig;
class QGridLayout;
class QCheckBox;
class KHButtonPair;

/** This tab contains the checkboxes for choosing which sensor may beep,
	* which ones are monitored at all, and how many faults must be detected
	* before alarm messages pop up.
	* If a certain sensor is disabled by the user, it's values won't be
	* displayed by the main widget and no message boxes will pop up when
	* critical values are detected. This makes sense if a certain sensor
	* does work improperly or is not or not correctly implemented in the board layout.
	* @author Ruediger Anlauf
	* @short tab 1 of the configuration dialog
  */

class KHTab1 : public QWidget {

friend class KHConfigItem;

   Q_OBJECT
public:
	/** constructor */
	KHTab1( QWidget *parent=0, const char *name=0 );
	/** destructor */
	~KHTab1();

protected:
	QGridLayout *grid;
	QCheckBox *enable[SensorIdSize];
	QCheckBox *beep[SensorIdSize];
	QLabel *label[SensorIdSize];
	KHButtonPair *faults[SensorIdSize];
	KHConfigItem *items[SensorIdSize];

private:
	KConfig *config;

protected slots:
	void configure( KHConfigItem::ButtonId button );

signals:
	void beepSettingChanged( bool value, SensorId sid );
	void enableSettingChanged( bool value, SensorId sid );
	void faultsSettingChanged( int value, SensorId sid );

protected: // Protected methods
  /**  */
  void createRow( SensorId sid );
};

#endif















































