/***************************************************************************
                          khfeatureprofile.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 31 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "khfeatureprofile.h"

FeatureProfilePrivate KHFeatureProfile::profile[SensorIdSize + auxValues];

KHFeatureProfile::KHFeatureProfile( sensors_chip_name chipname ){

	this->chipname = chipname;
	count = 0;

	for ( SensorId sid = Fan1; sid < End; sid++ ) {
		profile[sid].enabled = false;
		profile[sid].min = 0;
		profile[sid].max = 0;
		profile[sid].number = 0;
		profile[sid].alarm = 0;
		profile[sid].Name = "";
	}
	
}


KHFeatureProfile::~KHFeatureProfile(){
}


/**  */
int KHFeatureProfile::maxID( SensorId sid ){
	return profile[sid].max;
}


/**  */
int KHFeatureProfile::minID( SensorId sid ){
	return profile[sid].min;
}


/**  */
int KHFeatureProfile::featureID( SensorId sid ){
	return profile[sid].number;
}


/**  */
bool KHFeatureProfile::checkFeature( SensorId sid ){
	return profile[sid].enabled;
}


int KHFeatureProfile::alarmID( SensorId sid ){
	return profile[sid].alarm;
}

void KHFeatureProfile::parseFeatures(){
	int nr1 = 0, nr2 = 0;
	const sensors_feature_data *feature = 0;
	SensorId *sid = 0;
	int assoCount = 0;

	/* the data structures of lm_sensors are somewhat srewed: there are main features, and
		 asso(-ciated) features for each sensor item. For example, temp1 is a main feature, naming
		 temp sensor 1, and has two assos, temp hysteresis and overtemp limit. The latter two
     have certainly no alarm bindings; the following code tries to handle this situation
   */

	// parse the chip for the features it owns and store them in the profile
	do {
		feature = sensors_get_all_features( chipname, &nr1, &nr2 );
		if ( feature) debug( "%s\t\t%i\t%i", feature->name, feature->mapping, feature->number );
		if ( feature ) {
			if ( feature->mapping == -1 )
				sid = storeFeature( *feature );
			else if ( sid ) {
				assoCount++;
				if ( assoCount == 1 ) profile[*sid].min = feature->number;
				if ( assoCount == 2 ) {
					profile[*sid].max = feature->number;
					assoCount = 0;
				}
			}
			// these two are actually assos, but I consider them
			// important enough to give them main feature status
			if ( ( QString( feature->name ) == "beeps" ) || ( QString( feature->name ) == "beep_enable" ) ) storeFeature( *feature );
		}
	} while ( feature );

}

/**  */
int KHFeatureProfile::featureCount(){
	return count;
}

/**  */
QString KHFeatureProfile::name( SensorId sid ){
	return profile[sid].Name;
}



