/*
 *   This file is part of the Okteta Kasten Framework, made within the KDE community.
 *
 *   Copyright 2010, 2011, 2012 Alex Richardson <alex.richardson@gmx.de>
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) version 3, or any
 *   later version accepted by the membership of KDE e.V. (or its
 *   successor approved by the membership of KDE e.V.), which shall
 *   act as a proxy defined in Section 6 of version 3 of the license.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include "abstractstructureparser.h"
#include "../structuredefinitionfile.h"
#include "../script/scriptlogger.h"

AbstractStructureParser::AbstractStructureParser(const QString& pluginName,
        const QString& absolutePath)
        : mPluginName(pluginName), mAbsolutePath(absolutePath)
{
}

AbstractStructureParser::~AbstractStructureParser()
{
}

DataInformation::DataInformationEndianess AbstractStructureParser::byteOrderFromString(
        const QString& string, ScriptLogger* logger)
{
    const QString lower = string.toLower();
    if (lower == QLatin1String("bigendian") || lower == QLatin1String("big-endian"))
        return DataInformation::EndiannessBig;
    else if (lower == QLatin1String("littleendian") || lower == QLatin1String("little-endian"))
        return DataInformation::EndianessLittle;
    else if (lower == QLatin1String("fromsettings") || lower == QLatin1String("from-settings"))
        return DataInformation::EndianessFromSettings;
    else if (lower == QLatin1String("inherit"))
        return DataInformation::EndianessInherit;
    else
    {
        logger->warn().nospace() << "Unrecognized byte order '" << string
                << "', defaulting to 'inherit'";
        return DataInformation::EndianessInherit;
    }
}

QString AbstractStructureParser::byteOrderToString(DataInformation::DataInformationEndianess order)
{
    if (order == DataInformation::EndianessLittle)
        return QLatin1String("little-endian");
    if (order == DataInformation::EndiannessBig)
        return QLatin1String("big-endian");
    if (order == DataInformation::EndianessFromSettings)
        return QLatin1String("from-settings");
    return QLatin1String("inherit");
}
