# - Try to find FFMPEG
# Once done this will define
#  
#  FFMPEG_FOUND		 - system has FFMPEG
#  FFMPEG_INCLUDE_DIR	 - the include directories
#  FFMPEG_LIBRARY_DIR	 - the directory containing the libraries
#  FFMPEG_LIBRARIES	 - link these to use FFMPEG
#  FFMPEG_SWSCALE_FOUND	 - FFMPEG also has SWSCALE
#   

include(FindPackageHandleStandardArgs)

set( FFMPEG_HEADERS avformat.h avcodec.h avutil.h )
set( FFMPEG_PATH_SUFFIXES libavformat libavcodec libavutil )


if ( FFMPEG_LIBRARIES AND FFMPEG_INCLUDE_DIR)
    set (FFMPEG_FOUND TRUE)
endif ( FFMPEG_LIBRARIES AND FFMPEG_INCLUDE_DIR)

INCLUDE(FindPkgConfig)
if ( PKG_CONFIG_FOUND )
pkg_check_modules( PC_AVFORMAT libavformat )
pkg_check_modules( PC_AVCODEC libavcodec )
pkg_check_modules( PC_AVUTIL libavutil )
endif( PKG_CONFIG_FOUND)


find_library(AVFORMAT_LIBRARIES avformat
    HINTS ${PC_AVFORMAT_LIBDIR} ${PC_AVFORMAT_LIBRARY_DIRS}
)

find_library(AVCODEC_LIBRARIES avcodec
    HINTS ${PC_AVCODEC_LIBDIR} ${PC_AVCODEC_LIBRARY_DIRS}
)

find_library(AVUTIL_LIBRARIES avutil
    HINTS ${PC_AVUTIL_LIBDIR} ${PC_AVUTIL_LIBRARY_DIRS}
)


find_path(AVFORMAT_INCLUDE_DIR avformat.h
    HINTS ${PC_AVFORMAT_LIBDIR} ${PC_AVFROMAT_INCLUDE_DIRS}
    PATH_SUFFIXES libavformat
)

find_path(AVCODEC_INCLUDE_DIR avcodec.h
    HINTS ${PC_AVCODEC_LIBDIR} ${PC_AVCODEC_INCLUDE_DIRS}
    PATH_SUFFIXES libavcodec
)

find_path(AVUTIL_INCLUDE_DIR avutil.h
    HINTS ${PC_AVUTIL_LIBDIR} ${PC_AVUTIL_INCLUDE_DIRS}         
    PATH_SUFFIXES libavutil
)


SET( FFMPEG_INCLUDE_PATHS ${AVFORMAT_INCLUDE_DIR}
                               ${AVCODEC_INCLUDE_DIR}
                               ${AVUTIL_INCLUDE_DIR})


if (AVFORMAT_LIBRARIES AND AVCODEC_LIBRARIES AND AVUTIL_LIBRARIES )
SET (FFMPEG_LIBRARIES TRUE)
endif (AVFORMAT_LIBRARIES AND AVCODEC_LIBRARIES AND AVUTIL_LIBRARIES )


find_package_handle_standard_args(ffmpeg "Could not find ffmpeg; available at www.ffmpeg.org" FFMPEG_LIBRARIES FFMPEG_INCLUDE_PATHS)

mark_as_advanced(FFMPEG_INCLUDE_PATHS FFMPEG_LIBRARIES)
