/*
    This file is part of the Kasten Framework, part of the KDE project.

    Copyright 2008-2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ABSTRACTFILESYSTEMSYNCWITHREMOTEJOB_H
#define ABSTRACTFILESYSTEMSYNCWITHREMOTEJOB_H

// library
#include <abstractsyncwithremotejob.h>
#include <abstractmodelsynchronizer.h>

class KUrl;
class QWidget;
class QFile;


namespace Kasten
{

class AbstractModelFileSystemSynchronizer;

class AbstractFileSystemSyncWithRemoteJobPrivate;


class KASTENCORE_EXPORT AbstractFileSystemSyncWithRemoteJob : public AbstractSyncWithRemoteJob
{
  Q_OBJECT

  public:
    AbstractFileSystemSyncWithRemoteJob( AbstractModelFileSystemSynchronizer* synchronizer,
                                         const KUrl& url, AbstractModelSynchronizer::ConnectOption option );
    virtual ~AbstractFileSystemSyncWithRemoteJob();

  public: // KJob API
    virtual void start();

  protected: // API to be implemented
    virtual void startSyncWithRemote() = 0;

  protected:
    AbstractModelFileSystemSynchronizer* synchronizer() const;
    QFile* file() const;
    QWidget* widget() const;

  protected:
    void completeSync( bool success );

  protected:
    Q_PRIVATE_SLOT( d_func(), void syncWithRemote() )

  protected:
    Q_DECLARE_PRIVATE( AbstractFileSystemSyncWithRemoteJob )
};

}

#endif
