//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///    This class implements a kioslave to access zip files from KDE.
    ///    You can use it in QIODevice.ReadOnly or in QIODevice.WriteOnly mode, and it
    ///    behaves just as expected.
    ///    It can also be used in QIODevice.ReadWrite mode, in this case one can
    ///    append files to an existing zip archive. When you append new files, which
    ///    are not yet in the zip, it works as expected, i.e. the files are appended at the end.
    ///    When you append a file, which is already in the file, the reference to the
    ///    old file is dropped and the new one is added to the zip - but the
    ///    old data from the file itself is not deleted, it is still in the
    ///    zipfile. so when you want to have a small and garbage-free zipfile,
    ///    just read the contents of the appended zip file and write it to a new one
    ///    in QIODevice.WriteOnly mode. This is especially important when you don't want
    ///    to leak information of how intermediate versions of files in the zip
    ///    were looking.
    ///    For more information on the zip fileformat go to
    ///    http://www.pkware.com/products/enterprise/white_papers/appnote.html
    /// </remarks>        <author> Holger Schroeder <holger-kde@holgis.net>
    ///  </author>
    ///         <short> A class for reading/writing zip archives. </short>
    [SmokeClass("KZip")]
    public class KZip : KArchive, IDisposable {
        protected KZip(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KZip), this);
        }
        /// <remarks>
        ///  Describes the contents of the "extra field" for a given file in the Zip archive.
        ///      </remarks>        <short>    Describes the contents of the "extra field" for a given file in the Zip archive.</short>
        public enum ExtraField {
            NoExtraField = 0,
            ModificationTime = 1,
            DefaultExtraField = 1,
        }
        /// <remarks>
        ///  Describes the compression type for a given file in the Zip archive.
        ///      </remarks>        <short>    Describes the compression type for a given file in the Zip archive.</short>
        public enum Compression {
            NoCompression = 0,
            DeflateCompression = 1,
        }
        /// <remarks>
        ///  Creates an instance that operates on the given filename.
        ///  using the compression filter associated to given mimetype.
        /// <param> name="filename" is a local path (e.g. "/home/holger/myfile.zip")
        ///      </param></remarks>        <short>    Creates an instance that operates on the given filename.</short>
        public KZip(string filename) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KZip$", "KZip(const QString&)", typeof(void), typeof(string), filename);
        }
        /// <remarks>
        ///  Creates an instance that operates on the given device.
        ///  The device can be compressed (KFilterDev) or not (QFile, etc.).
        ///  @warning Do not assume that giving a QFile here will decompress the file,
        ///  in case it's compressed!
        /// <param> name="dev" the device to access
        ///      </param></remarks>        <short>    Creates an instance that operates on the given device.</short>
        public KZip(QIODevice dev) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KZip#", "KZip(QIODevice*)", typeof(void), typeof(QIODevice), dev);
        }
        /// <remarks>
        ///  Call this before writeFile or prepareWriting, to define what the next
        ///  file to be written should have in its extra field.
        /// <param> name="ef" the type of "extra field"
        /// </param></remarks>        <short>    Call this before writeFile or prepareWriting, to define what the next  file to be written should have in its extra field.</short>
        ///         <see> extraField</see>
        public void SetExtraField(KZip.ExtraField ef) {
            interceptor.Invoke("setExtraField$", "setExtraField(KZip::ExtraField)", typeof(void), typeof(KZip.ExtraField), ef);
        }
        /// <remarks>
        ///  The current type of "extra field" that will be used for new files.
        /// </remarks>        <return> the current type of "extra field"
        /// </return>
        ///         <short>    The current type of "extra field" that will be used for new files.</short>
        ///         <see> setExtraField</see>
        public KZip.ExtraField extraField() {
            return (KZip.ExtraField) interceptor.Invoke("extraField", "extraField() const", typeof(KZip.ExtraField));
        }
        /// <remarks>
        ///  Call this before writeFile or prepareWriting, to define whether the next
        ///  files to be written should be compressed or not.
        /// <param> name="c" the new compression mode
        /// </param></remarks>        <short>    Call this before writeFile or prepareWriting, to define whether the next  files to be written should be compressed or not.</short>
        ///         <see> compression</see>
        public void SetCompression(KZip.Compression c) {
            interceptor.Invoke("setCompression$", "setCompression(KZip::Compression)", typeof(void), typeof(KZip.Compression), c);
        }
        /// <remarks>
        ///  The current compression mode that will be used for new files.
        /// </remarks>        <return> the current compression mode
        /// </return>
        ///         <short>    The current compression mode that will be used for new files.</short>
        ///         <see> setCompression</see>
        public KZip.Compression compression() {
            return (KZip.Compression) interceptor.Invoke("compression", "compression() const", typeof(KZip.Compression));
        }
        /// <remarks>
        ///  Write data to a file that has been created using prepareWriting().
        /// <param> name="data" a pointer to the data
        /// </param><param> name="size" the size of the chunk
        /// </param></remarks>        <return> true if successful, false otherwise
        ///      </return>
        ///         <short>    Write data to a file that has been created using prepareWriting().</short>
        [SmokeMethod("writeData(const char*, qint64)")]
        public override bool WriteData(string data, long size) {
            return (bool) interceptor.Invoke("writeData$$", "writeData(const char*, qint64)", typeof(bool), typeof(string), data, typeof(long), size);
        }
        [SmokeMethod("doWriteSymLink(const QString&, const QString&, const QString&, const QString&, mode_t, time_t, time_t, time_t)")]
        protected override bool DoWriteSymLink(string name, string target, string user, string group, long perm, int atime, int mtime, int ctime) {
            return (bool) interceptor.Invoke("doWriteSymLink$$$$$$$$", "doWriteSymLink(const QString&, const QString&, const QString&, const QString&, mode_t, time_t, time_t, time_t)", typeof(bool), typeof(string), name, typeof(string), target, typeof(string), user, typeof(string), group, typeof(long), perm, typeof(int), atime, typeof(int), mtime, typeof(int), ctime);
        }
        [SmokeMethod("doPrepareWriting(const QString&, const QString&, const QString&, qint64, mode_t, time_t, time_t, time_t)")]
        protected override bool DoPrepareWriting(string name, string user, string group, long size, long perm, int atime, int mtime, int ctime) {
            return (bool) interceptor.Invoke("doPrepareWriting$$$$$$$$", "doPrepareWriting(const QString&, const QString&, const QString&, qint64, mode_t, time_t, time_t, time_t)", typeof(bool), typeof(string), name, typeof(string), user, typeof(string), group, typeof(long), size, typeof(long), perm, typeof(int), atime, typeof(int), mtime, typeof(int), ctime);
        }
        /// <remarks>
        ///  Write data to a file that has been created using prepareWriting().
        /// <param> name="size" the size of the file
        /// </param></remarks>        <return> true if successful, false otherwise
        ///      </return>
        ///         <short>    Write data to a file that has been created using prepareWriting().</short>
        [SmokeMethod("doFinishWriting(qint64)")]
        protected override bool DoFinishWriting(long size) {
            return (bool) interceptor.Invoke("doFinishWriting$", "doFinishWriting(qint64)", typeof(bool), typeof(long), size);
        }
        /// <remarks>
        ///  Opens the archive for reading.
        ///  Parses the directory listing of the archive
        ///  and creates the KArchiveDirectory/KArchiveFile entries.
        /// <param> name="mode" the mode of the file
        ///      </param></remarks>        <short>    Opens the archive for reading.</short>
        [SmokeMethod("openArchive(QIODevice::OpenMode)")]
        protected override bool OpenArchive(uint mode) {
            return (bool) interceptor.Invoke("openArchive$", "openArchive(QIODevice::OpenMode)", typeof(bool), typeof(uint), mode);
        }
        [SmokeMethod("closeArchive()")]
        protected override bool CloseArchive() {
            return (bool) interceptor.Invoke("closeArchive", "closeArchive()", typeof(bool));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("doWriteDir(const QString&, const QString&, const QString&, mode_t, time_t, time_t, time_t)")]
        protected override bool DoWriteDir(string name, string user, string group, long perm, int atime, int mtime, int ctime) {
            return (bool) interceptor.Invoke("doWriteDir$$$$$$$", "doWriteDir(const QString&, const QString&, const QString&, mode_t, time_t, time_t, time_t)", typeof(bool), typeof(string), name, typeof(string), user, typeof(string), group, typeof(long), perm, typeof(int), atime, typeof(int), mtime, typeof(int), ctime);
        }
        ~KZip() {
            interceptor.Invoke("~KZip", "~KZip()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KZip", "~KZip()", typeof(void));
        }
    }
}
