/*
 * kless.h. Part of the KDE project.
 *
 * Copyright (C) 1998 Matthias Ettrich
 *
 */

#ifndef _KLESS_H_
#define _KLESS_H_

#include <kapp.h>
#include <kmainwindow.h>
#include <kurl.h>
#include <qmlined.h>


class KLess : public KMainWindow {
  Q_OBJECT
public:
  KLess();
  ~KLess(){};

  void loadFile(const QString & filename);
  void loadFile(const KURL & u);
  QMultiLineEdit* edit;
    
  bool queryClose();
  bool queryExit();

public slots:
  void dropEvent( QDropEvent *);
  void slotLoadFile();
  void slotNewWindow();
  void slotToolbarClicked(int);

protected:
  void saveProperties(KConfig*);
  void readProperties(KConfig*);


private:
  enum {TOOLBAR_EXIT, TOOLBAR_OPEN};
};

#endif
