/***************************************************************************
                            VoiceManager.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 Manages the voices used by synthesizers.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Manages internally the voices used by synth devices.

*/
public class  VoiceManager implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected VoiceManager(Class dummy){}


/** 
 Cronstructor.
     
*/
	private native void newVoiceManager( int totalvoices);
	public VoiceManager( int totalvoices) {
		newVoiceManager( totalvoices);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Allocates a voice used in channel <code>chn</code>, and playing key <code>key</code>

*/
	public native int allocateVoice( int chn, int key);

/** 
 Deallocates the voice with ID <code>id.</code>

*/
	public native void deallocateVoice( int identifier);

/** 
 initSearch() must be called always before {@link #search} to initialize
 internal variables.

*/
	public native void initSearch();

/** 
 Returns -1 if channel chn is not currently used, or a voice using
 channel <code>chn</code> if any.

 Calling search repeteadly, will return all the voices using channel 
 <code>chn</code>, and a -1 after the last one.

*/
	public native int search( int chn);

/** 
 This is a convenience function that differs from the above in that it also
 looks for a specific note (the second parameter)

*/
	public native int search( int chn, int note);

/** 
 Returns the channel that voice <code>v</code> is using.
     
*/
	public native int channel( int v);

/** 
 Returns the note that voice <code>v</code> is playing.
     
*/
	public native int note( int v);

/** 
 Returns true or false if the voice <code>v</code> is being used or not respectively.
     
*/
	public native int used( int v);

/** 
 Clears the lists of used voices.
     
*/
	public native void clearLists();
}
