/***************************************************************************
                            KXMLGUIClientInterface.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
public interface KXMLGUIClientInterface {

/** 
 Retrieve an action of the client by name.
 This method is provided for convenience, as it uses {@link #actionCollection}
 to get the action object.
   
*/
	KAction action( String name);

/** 
 Retrieve an action for a given {@link QDomElement}. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.
   
*/
	KAction action( QDomElement element);

/** 
 Retrieve the entire action collection for the GUI client
   
*/
	KActionCollection actionCollection();

/** 

*/
	KInstanceInterface instance();

/** 

*/
	QDomDocument domDocument();

/** 
 This will return the name of the XML file as set by {@link #setXMLFile}.
 If {@link #setXML} is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
	String xmlFile();
	String localXMLFile();

/** 

   
*/
	void setXMLGUIBuildDocument( QDomDocument doc);

/** 

   
*/
	QDomDocument xmlguiBuildDocument();

/** 
 This method is called by the {@link KXMLGUIFactory} as soon as the client
 is added to the KXMLGUIFactory's GUI.
   
*/
	void setFactory( KXMLGUIFactory factory);

/** 
 Retrieve a pointer to the {@link KXMLGUIFactory} this client is
 associated with (will return null if the client's GUI has not been built
 by a KXMLGUIFactory.
   
*/
	KXMLGUIFactory factory();

/** 
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or null if it has no
 parent client assigned.
   
*/
	KXMLGUIClientInterface parentClient();

/** 
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.
   
*/
	void insertChildClient( KXMLGUIClientInterface child);

/** 
 Remove the given <code>child</code> from the client's children list.
   
*/
	void removeChildClient( KXMLGUIClientInterface child);

/** 
 A client can have an own {@link KXMLGUIBuilder}.
 Use this method to assign your builder instance to the client (so that the
 {@link KXMLGUIFactory} can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.
   
*/
	void setClientBuilder( KXMLGUIBuilderInterface builder);

/** 
 Retrieve the client's GUI builder or null if no client specific
 uilder has been assigned via {@link #setClientBuilder}
   
*/
	KXMLGUIBuilderInterface clientBuilder();

/** 
 Force this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.
   
*/
	void reloadXML();
	void unplugActionList( String name);
}
