/***************************************************************************
                            KThemeStyle.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDE themed styles.

 It provides methods for
 drawing most widgets with user-specified borders, highlights, pixmaps,
 etc. It also handles various other settings such as scrollbar types,
 rounded buttons, and shading types. For a full list of parameters this
 class handles refer to the KDE theme configuration documentation.

 
 See {@link KThemeStyleSignals} for signals emitted by KThemeStyle.

 See {@link KThemeStyleEventHandling} for event handlers to override in subclasses of KThemeStyle.

 @short 
 KDE themed styles.
*/
public class KThemeStyle extends KThemeBase  {
	protected KThemeStyle(Class dummy){super((Class) null);}


/** 
 Construct a new {@link KThemeStyle} object.

*/
	private native void newKThemeStyle( String configFile);
	public KThemeStyle( String configFile) {
		super((Class) null);
		newKThemeStyle( configFile);
	}
	private native void newKThemeStyle();
	public KThemeStyle() {
		super((Class) null);
		newKThemeStyle();
	}
	protected native void finalize() throws InternalError;
	public native void polish( QWidget arg1);
	public native void unPolish( QWidget arg1);

/** 
 By default this just sets the background brushes to the pixmapped
 background.
     
*/
	public native void polish( QApplication app);
	public native void unPolish( QApplication arg1);
	public native void polish( QPalette pal);

/** 
 This is a convenience method for drawing widgets with
 borders, highlights, pixmaps, colors, etc...
 You specify the widget type and it will draw it according to the
 config file settings.

*/
	public native void drawBaseButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, boolean rounded, int type, QBrush fill);
	public native void drawBaseButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw a mask with for widgets that may be rounded. 

Currently used
 by pushbuttons and comboboxes.

*/
	public native void drawBaseMask( QPainter p, int x, int y, int w, int h, boolean rounded);

/** 
 Draw a pushbutton.

 This calls {@link #drawBaseButton} with <code>PushButton</code> as the
 widget type.
     
*/
	public native void drawButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, QBrush fill);
	public native void drawButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw a bevel button.

 This calls {@link #drawBaseButton} with Bevel as the
 widget type.
     
*/
	public native void drawBevelButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, QBrush fill);
	public native void drawBevelButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw a toolbar button.
     
*/
	public native void drawKToolBarButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, boolean raised, boolean enabled, boolean popup, int type, String btext, QPixmap icon, QFont font, QWidget btn);
	public native void drawKToolBarButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw the handle used in toolbars.
     
*/
	public native void drawKBarHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, int type, QBrush fill);
	public native void drawKBarHandle( QPainter p, int x, int y, int w, int h, QColorGroup g, int type);

/** 
 Draw a toolbar.
     
*/
	public native void drawKToolBar( QPainter p, int x, int y, int w, int h, QColorGroup g, int type, QBrush fill);
	public native void drawKToolBar( QPainter p, int x, int y, int w, int h, QColorGroup g, int type);

/** 
 Return the space available in a pushbutton, taking configurable
 borders and highlights into account.
     
*/
	public native QRect buttonRect( int x, int y, int w, int h);

/** 
 Draw an arrow in the style specified by the config file.
     
*/
	public native void drawArrow( QPainter p, int type, boolean down, int x, int y, int w, int h, QColorGroup g, boolean enabled, QBrush fill);
	public native void drawArrow( QPainter p, int type, boolean down, int x, int y, int w, int h, QColorGroup g);

/** 
 Return the size of the exclusive indicator pixmap if one is specified
 in the config file, otherwise it uses the base style's size.
     
*/
	public native QSize exclusiveIndicatorSize();

/** 
 Draw an exclusive indicator widget.

 If a pixmap is specified in the
 config file that is used, otherwise the base style's widget is drawn.
     
*/
	public native void drawExclusiveIndicator( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean on, boolean down, boolean enabled);
	public native void drawExclusiveIndicator( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean on);

/** 
 Set the mask of an exclusive indicator widget.

 If a pixmap is specified
 it is masked according to it's transparent pixels, otherwise the
 base style's mask is used.
     
*/
	public native void drawExclusiveIndicatorMask( QPainter p, int x, int y, int w, int h, boolean on);

/** 
 Set the mask of an indicator widget.

 If a pixmap is specified
 it is masked according to it's transparent pixels, otherwise the
 base style's mask is used.
     
*/
	public native void drawIndicatorMask( QPainter p, int x, int y, int w, int h, int state);

/** 
 Set the mask for pushbuttons.
     
*/
	public native void drawButtonMask( QPainter p, int x, int y, int w, int h);

/** 
 Set the mask for combo boxes.
     
*/
	public native void drawComboButtonMask( QPainter p, int x, int y, int w, int h);

/** 
 Return the size of the indicator pixmap if one is specified
 in the config file, otherwise it uses the base style's size.
     
*/
	public native QSize indicatorSize();

/** 
 Draw an indicator widget.

 If a pixmap is specified in the
 config file that is used, otherwise the base style's widget is drawn.
     
*/
	public native void drawIndicator( QPainter p, int x, int y, int w, int h, QColorGroup g, int state, boolean down, boolean enabled);
	public native void drawIndicator( QPainter p, int x, int y, int w, int h, QColorGroup g, int state);

/** 
 Draw a combobox.
     
*/
	public native void drawComboButton( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, boolean editable, boolean enabled, QBrush fill);
	public native void drawComboButton( QPainter p, int x, int y, int w, int h, QColorGroup g);

/** 
 Draw a pushbutton.
     
*/
	public native void drawPushButton( QPushButton btn, QPainter p);

/** 
 Return the amount of button content displacement specified by the
 config file.
     
*/
	public native void getButtonShift( int x, int y);

/** 
 Return the frame width.
     
*/
	public native int defaultFrameWidth();

/** 
 Calculate the metrics of the scrollbar controls according to the
 layout specified by the config file.
     
*/
	public native void scrollBarMetrics( QScrollBar arg1, int arg2, int arg3, int arg4, int arg5);

/** 
 Draw a themed scrollbar.
     
*/
	public native void drawScrollBarControls( QPainter arg1, QScrollBar arg2, int sliderStart, int controls, int activeControl);

/** 
 Return the control that the given point is over according to the
 layout in the config file.
     
*/
	public native int scrollBarPointOver( QScrollBar arg1, int sliderStart, QPoint arg2);

/** 
 Return the configurable default slider length.
     
*/
	public native int sliderLength();

/** 
 Draw a slider control.
     
*/
	public native void drawSlider( QPainter p, int x, int y, int w, int h, QColorGroup g, int arg1, boolean tickAbove, boolean tickBelow);

/** 
 Draw a slider groove.
     
*/
	public native void drawSliderGroove( QPainter p, int x, int y, int w, int h, QColorGroup g, short c, int arg1);

/** 
 Draw the mask for a slider (both the control and groove.
     
*/
	public native void drawSliderMask( QPainter p, int x, int y, int w, int h, int arg1, boolean tickAbove, boolean tickBelow);

/** 
 Convience method for drawing themed scrollbar grooves.

 Since the
 grooves may be a scaled pixmap you cannot just bitblt the pixmap at
 any offset. This generates a cached pixmap at full size if needed and
 then copies the requested area.

*/
	public native void drawScrollBarGroove( QPainter p, QScrollBar sb, boolean horizontal, QRect r, QColorGroup g);

/** 
 Draw a shaded rectangle using the given style.

*/
	public native void drawShade( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean sunken, boolean rounded, int hWidth, int bWidth, int style);

/** 
 Draw the text for a pushbutton.
     
*/
	public native void drawPushButtonLabel( QPushButton btn, QPainter p);

/** 
 Draw a menubar.
     
*/
	public native void drawKMenuBar( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean macMode, QBrush fill);
	public native void drawKMenuBar( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean macMode);

/** 
 Draw a menubar item.
     
*/
	public native void drawKMenuItem( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean active, QMenuItem item, QBrush fill);
	public native void drawKMenuItem( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean active, QMenuItem item);

/** 
 Return the width of the splitter as specified in the config file.
     
*/
	public native int splitterWidth();

/** 
 Draw a splitter widget.
     
*/
	public native void drawSplitter( QPainter p, int x, int y, int w, int h, QColorGroup g, int arg1);

/** 
 Draw a checkmark.
     
*/
	public native void drawCheckMark( QPainter p, int x, int y, int w, int h, QColorGroup g, boolean act, boolean dis);

/** 
 Draw a menu item.

 Note: This method manually handles applying
 inactive menu backgrounds to the entire widget.
     
*/
	public native void drawPopupMenuItem( QPainter p, boolean checkable, int maxpmw, int tab, QMenuItem mi, QPalette pal, boolean act, boolean enabled, int x, int y, int w, int h);
	public native int popupMenuItemHeight( boolean checkable, QMenuItem mi, QFontMetrics fm);

/** 
 Draw the focus rectangle.
     
*/
	public native void drawFocusRect( QPainter p, QRect r, QColorGroup g, QColor c, boolean atBorder);
	public native void drawFocusRect( QPainter p, QRect r, QColorGroup g);

/** 
 Draw a {@link KProgess} bar.
     
*/
	public native void drawKProgressBlock( QPainter p, int x, int y, int w, int h, QColorGroup g, QBrush fill);

/** 
 Return the background for {@link KProgress}.
     
*/
	public native void getKProgressBackground( QColorGroup g, QBrush bg);
	public native void tabbarMetrics( QTabBar arg1, int arg2, int arg3, int arg4);
	public native void drawTab( QPainter arg1, QTabBar arg2, int arg3, boolean selected);
	public native void drawTabMask( QPainter arg1, QTabBar arg2, int arg3, boolean selected);
}
