/***************************************************************************
                            KThemeBase.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a base class for KDE themed styles. It implements a cache,
 configuration file parsing, pixmap scaling, gradients, and a lot
 of inline methods for accessing user specified parameters.

 Note that this class does not actually implement any themes. It just
 provides the groundwork for doing so. The only reason to use this class
 directly is if you plan to reimplement all of the widgets. Otherwise,
 refer to KThemeStyle for a fully themed style you can derive from.

 See {@link KThemeBaseSignals} for signals emitted by KThemeBase.

 See {@link KThemeBaseEventHandling} for event handlers to override in subclasses of KThemeBase.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short 
 This is a base class for KDE themed styles.
*/
public class KThemeBase extends KStyle  {
	protected KThemeBase(Class dummy){super((Class) null);}


/** 
 Constructs a new KThemeBase object.
     
*/
	private native void newKThemeBase( String configFile);
	public KThemeBase( String configFile) {
		super((Class) null);
		newKThemeBase( configFile);
	}
	protected native void finalize() throws InternalError;

/** 
 The scaling type specified by the KConfig file.

*/
	public native int scaleHint( int widget);

/** 
 The gradient type specified by the KConfig file.

*/
	public native int gradientHint( int widget);

/** 
 The color group specified for a given widget.
 If a color group is set in the theme configuration
 that is used, otherwise defaultColor is returned.

     
*/
	public native QColorGroup colorGroup( QColorGroup defaultGroup, int widget);
	public native QBrush pixmapBrush( QColorGroup group, int role, int w, int h, int widget);

/** 
 True if the widget has a pixmap or gradient specified.
     
*/
	public native boolean isPixmap( int widget);

/** 
 True if the widget has a color group specified.
     
*/
	public native boolean isColor( int widget);

/** 
 True if the user specified a 3D focus rectangle
     
*/
	public native boolean is3DFocus();

/** 
 If the user specified a 3D focus rectangle, they may also specify an
 offset from the default rectangle to use when drawing it. This returns
 the specified offset.
     
*/
	public native int focusOffset();

/** 
 The border width of the specified widget.
     
*/
	public native int borderWidth( int widget);

/** 
 Pixmap border width of the specified widget.
     
*/
	public native int pixBorderWidth( int widget);

/** 
 Returns the border pixmap if enabled for the specified widget. This
 will contain the originial pixmap, plus the edges separated in
 KThemePixmap.border() if valid. If invalid it will return NULL.
     
*/
	public native KThemePixmap borderPixmap( int widget);

/** 
 The highlight width of the specified widget.
     
*/
	public native int highlightWidth( int widget);

/** 
 The border plus highlight width of the widget.
     
*/
	public native int decoWidth( int widget);

/** 
 The extent (width for vertical, height for horizontal) requested
 for the scrollbars.
     
*/
	public native int getSBExtent();

/** 
 The scrollbar button layout.
     
*/
	public native int scrollBarLayout();

/** 
 The arrow type.
     
*/
	public native int arrowType();

/** 
 The shading type.
     
*/
	public native int shade();

/** 
 The frame width.
     
*/
	public native int frameWidth();

/** 
 The splitter width.
     
*/
	public native int splitWidth();

/** 
 The contrast for some bevel effects such as reverse gradient.
     
*/
	public native int bevelContrast( int widget);

/** 
 The button text X shift.
     
*/
	public native int buttonXShift();

/** 
 The button text Y shift.
     
*/
	public native int buttonYShift();

/** 
 Returns either the slider length of the slider pixmap if available,
 otherwise the length specified in the config file.
     
*/
	public native int sliderButtonLength();

/** 
 True if rounded buttons are requested.
     
*/
	public native boolean roundButton();

/** 
 True if rounded comboboxes are requested.
     
*/
	public native boolean roundComboBox();

/** 
 True if rounded slider grooves are requested.
     
*/
	public native boolean roundSlider();

/** 
 True if a line should be drawn on the bottom of active tabs.
     
*/
	public native boolean activeTabLine();

/** 
 True if a line should be drawn on the bottom of inactive tabs.
     
*/
	public native boolean inactiveTabLine();

/** 
 Returns the current uncached pixmap for the given widget. This will
 usually be either the last scaled or gradient pixmap if those have
 been specified in the config file, the original pixmap if not, or NULL
 if no pixmap has been specified.
     
*/
	public native KThemePixmap uncached( int widget);

/** 
 Returns the pixmap for the given widget at the specified width and
 height. This will return NULL if no pixmap or gradient is specified.
 It may also return a different sized pixmap if the scaling
 is set to Tiled. When using this method, you should call it using
 the needed width and height then use QPainter.drawTiledPixmap to
 paint it. Doing this, if the pixmap is scaled it will be the proper
 size, otherwise it will be tiled.

*/
	public native KThemePixmap scalePixmap( int w, int h, int widget);

/** 
 This method reads a configuration file and applies it to the user's
 kstylerc file. It does not signal applications to reload via the
 KDEChangeGeneral atom, if you want to do this you must do so yourself.
 See kcmdisplay's general.cpp for an example.

*/
	public static native void applyConfigFile( String file);

/** 
 Returns a QImage for the given widget if the widget is scaled, NULL
 otherwise. QImages of the original pixmap are stored for scaled
 widgets in order to facilitate fast and accurate smooth-scaling. This
 also saves us a conversion from a pixmap to an image then back again.
     
*/
	protected native QImage image( int widget);

/** 
 Returns the gradient high color if one is specified, NULL otherwise.
     
*/
	protected native QColor gradientHigh( int widget);

/** 
 Returns the gradient low color if one is specified, NULL otherwise.
     
*/
	protected native QColor gradientLow( int widget);

/** 
 Reads in all the configuration file entries supported.

*/
	protected native void readConfig( int colorStyle);
	protected native void readConfig();
	protected native void readWidgetConfig( int i, KConfig config, String pixnames, String brdnames, int[] loadArray);
	protected native void copyWidgetConfig( int sourceID, int destID, String pixnames, String brdnames);

/** 
 Makes a full color group based on the given foreground and background
 colors. This is the same code used by KDE (kapp.cpp) in previous
 versions.
     
*/
	protected native QColorGroup makeColorGroup( QColor fg, QColor bg, int style);
	protected native QColorGroup makeColorGroup( QColor fg, QColor bg);
	protected native KThemePixmap scale( int w, int h, int widget);
	protected native KThemePixmap scaleBorder( int w, int h, int type);
	protected native KThemePixmap gradient( int w, int h, int widget);
	protected native KThemePixmap blend( int widget);
	protected native void generateBorderPix( int i);
	protected native void applyResourceGroup( KConfig config, int i);
	protected native void applyMiscResourceGroup( KConfig config);
	protected native void readResourceGroup( int i, String pixnames, String brdnames, int[] loadArray);
	protected native void readMiscResourceGroup();

/** 
 Attempts to load a pixmap from the default KThemeBase locations.
     
*/
	protected native KThemePixmap loadPixmap( String name);

/** 
 Attempts to load a image from the default KThemeBase locations.
     
*/
	protected native QImage loadImage( String name);
	public static final int FullScale = 0;
	public static final int HorizontalScale = 1;
	public static final int VerticalScale = 2;
	public static final int TileScale = 3;
	public static final int MotifArrow = 0;
	public static final int LargeArrow = 1;
	public static final int SmallArrow = 2;
	public static final int Motif = 0;
	public static final int Windows = 1;
	public static final int Next = 2;
	public static final int KDE = 3;
	public static final int SBBottomLeft = 0;
	public static final int SBBottomRight = 1;
	public static final int SBOpposite = 2;
	public static final int GrNone = 0;
	public static final int GrHorizontal = 1;
	public static final int GrVertical = 2;
	public static final int GrDiagonal = 3;
	public static final int GrPyramid = 4;
	public static final int GrRectangle = 5;
	public static final int GrElliptic = 6;
	public static final int GrReverseBevel = 7;
	public static final int PushButton = 0;
	public static final int ComboBox = 0;
	public static final int HScrollBarSlider = 1;
	public static final int VScrollBarSlider = 2;
	public static final int Bevel = 3;
	public static final int ToolButton = 4;
	public static final int ScrollButton = 5;
	public static final int HScrollDeco = 6;
	public static final int VScrollDeco = 7;
	public static final int ComboDeco = 8;
	public static final int MenuItem = 9;
	public static final int InactiveTab = 10;
	public static final int ArrowUp = 11;
	public static final int ArrowDown = 12;
	public static final int ArrowLeft = 13;
	public static final int ArrowRight = 14;
	public static final int PushButtonDown = 15;
	public static final int ComboBoxDown = 16;
	public static final int HScrollBarSliderDown = 17;
	public static final int VScrollBarSliderDown = 18;
	public static final int BevelDown = 19;
	public static final int ToolButtonDown = 20;
	public static final int ScrollButtonDown = 21;
	public static final int HScrollDecoDown = 22;
	public static final int VScrollDecoDown = 23;
	public static final int ComboDecoDown = 24;
	public static final int MenuItemDown = 25;
	public static final int ActiveTab = 26;
	public static final int SunkenArrowUp = 27;
	public static final int SunkenArrowDown = 28;
	public static final int SunkenArrowLeft = 29;
	public static final int SunkenArrowRight = 30;
	public static final int HScrollGroove = 31;
	public static final int VScrollGroove = 32;
	public static final int Slider = 33;
	public static final int SliderGroove = 34;
	public static final int IndicatorOn = 35;
	public static final int IndicatorOff = 36;
	public static final int ExIndicatorOn = 37;
	public static final int ExIndicatorOff = 38;
	public static final int HBarHandle = 39;
	public static final int VBarHandle = 40;
	public static final int ToolBar = 41;
	public static final int Splitter = 42;
	public static final int CheckMark = 43;
	public static final int MenuBar = 44;
	public static final int DisArrowUp = 45;
	public static final int DisArrowDown = 46;
	public static final int DisArrowLeft = 47;
	public static final int DisArrowRight = 48;
	public static final int ProgressBar = 49;
	public static final int ProgressBg = 50;
	public static final int MenuBarItem = 51;
	public static final int Background = 52;
}
