/***************************************************************************
                            KPanelMenu.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 DCop client menu class for the Kicker panel that will insert a submenu into
 the KDE menu.

 See {@link KPanelMenuSignals} for signals emitted by KPanelMenu.

 See {@link KPanelMenuEventHandling} for event handlers to override in subclasses of KPanelMenu.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short 
 DCop client menu class for the Kicker panel that will insert a submenu into
 the KDE menu.
*/
public class KPanelMenu extends QObject implements  DCOPObjectInterface {
	protected KPanelMenu(Class dummy){super((Class) null);}


/** 
 Constructs a new menu with the given title. 
     
*/
	private native void newKPanelMenu( String title, QObject parent, String name);
	public KPanelMenu( String title, QObject parent, String name) {
		super((Class) null);
		newKPanelMenu( title, parent, name);
	}
	private native void newKPanelMenu( String title);
	public KPanelMenu( String title) {
		super((Class) null);
		newKPanelMenu( title);
	}

/** 
 Same as above, but with an icon for the submenu item.
     
*/
	private native void newKPanelMenu( QPixmap icon, String title, QObject parent, String name);
	public KPanelMenu( QPixmap icon, String title, QObject parent, String name) {
		super((Class) null);
		newKPanelMenu( icon, title, parent, name);
	}

/** 
 Constructs a new (sub)menu with a given id.
     
*/
	private native void newKPanelMenu( QObject parent, String name);
	public KPanelMenu( QObject parent, String name) {
		super((Class) null);
		newKPanelMenu( parent, name);
	}

/** 
 Make sure you actually destroy this thing or the menu will never go
 away until this application quits or Kicker restarts ;-)
     
*/
	protected native void finalize() throws InternalError;

/** 
 Inserts an item into the menu.
     
*/
	public native int insertItem( String text, int identifier);
	public native int insertItem( String text);

/** 
 Inserts an item with a icon. The icon name must be a full path.
     
*/
	public native int insertItem( QPixmap icon, String text, int identifier);
	public native int insertItem( QPixmap icon, String text);

/**  
 Inserts a sub menu with a icon. The icon name must be a full path.
     
*/
	public native KPanelMenu insertMenu( QPixmap icon, String text, int identifier);
	public native KPanelMenu insertMenu( QPixmap icon, String text);

/** 
 Clears the menu.
     
*/
	public native void clear();

/** 

     
*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] reply);
	protected native void init( QPixmap icon, String title);

        // From DCOPObjectInterfac


	public native String objId();


/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, String data, String replyType, String replyData);

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();


/**
 Connect to a DCOP signal

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnect a DCOP signal

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**

 {@link DCOPObjectProxy}

*/
	public static native boolean hasObject( String objId);

/**

 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/**
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);
}
