package org.kde.koala;
import org.kde.qt.*;


/** {@link KKeyDialog} emits these signals */
public interface KKeyDialogSignals {

/**  
 The User3 button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotUser3} is not replaced.
     
*/
	void user3Clicked();
	void destroyed();

/**  
 The Yes button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotYes} is not replaced.
     
*/
	void yesClicked();

/**  
 The Help button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotHelp} is not replaced.
     
*/
	void helpClicked();

/**  
 The Apply button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotApply} is not replaced.
     
*/
	void applyClicked();

/**  
 The Default button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/**  
 The Try button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotTry} is not replaced.
     
*/
	void tryClicked();

/**  
 The No button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotNo} is not replaced.
     
*/
	void noClicked();

/**  
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/**  
 The Cancel button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/**  
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KKeyDialog#applyClicked} instead.
     
*/
	void apply();

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KKeyDialog#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KKeyDialog#delayedDestruct} instead.
     
*/
	void finished();

/**  
 The background tile has changed.
     
*/
	void backgroundChanged();

/**  
 The User1 button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 Emitted when the margin size and/or spacing size 
 have changed.

 Use {@link KKeyDialog#marginHint} and  {@link KKeyDialog#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/**  
 The Close button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotClose} is not replaced.
     
*/
	void closeClicked();

/**  
 The OK button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/**  
 The User2 button was pressed. This signal is only emitted if
 {@link KKeyDialog#slotUser2} is not replaced.
     
*/
	void user2Clicked();
}

