/***************************************************************************
                            KFontDialog.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the {@link KFontChooser} widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method {@link KFontDialog#getFont},
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.

 Example:

 <pre>
      QFont myFont;
      int result = KFontDialog.getFont( myFont );
      if ( result == KFontDialog.Accepted )
            ...
 </pre>

 See {@link KFontDialogSignals} for signals emitted by KFontDialog.

 See {@link KFontDialogEventHandling} for event handlers to override in subclasses of KFontDialog.

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontDialog.java,v 1.2.2.2 2001/09/09 20:27:34 rdale Exp $
 
 @short A font selection dialog.

*/
public class KFontDialog extends KDialogBase  {
	protected KFontDialog(Class dummy){super((Class) null);}


/** 
 Constructs a font selection dialog.

   
*/
	private native void newKFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame);
	public KFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame) {
		super((Class) null);
		newKFontDialog( parent, name, onlyFixed, modal, fontlist, makeFrame);
	}
	private native void newKFontDialog();
	public KFontDialog() {
		super((Class) null);
		newKFontDialog();
	}

/** 
 Sets the currently selected font in the dialog.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native QFont font();

/** 
 Sets the currently selected charset in the dialog.
   
*/
	public native void setCharset( String charset);

/** 

*/
	public native String charset();

/** 
 Creates a modal font dialog, lets the user choose a font,
 and returns when the dialog is closed.

*/
	public static native int getFont( QFont theFont, boolean onlyFixed, QWidget parent, boolean makeFrame);
	public static int getFont( QFont theFont, boolean onlyFixed, QWidget parent) {
		return getFont(theFont, onlyFixed, parent, true);
	}
	public static int getFont( QFont theFont, boolean onlyFixed) {
		return getFont(theFont, onlyFixed, null, true);
	}
	public static native int getFont( QFont theFont);

/** 
 When you are not only interested in the font selected, but also
 in the example string typed in, you can call this method.

*/
	public static native int getFontAndText( QFont theFont, StringBuffer theString, boolean onlyFixed, QWidget parent, boolean makeFrame);
	public static native int getFontAndText( QFont theFont, StringBuffer theString);
}
