/***************************************************************************
                            KCommandHistory.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The command history stores a (user) configurable amount of
 Commands. It keeps track of its size and deletes commands
 if it gets too large. The user can set a maximum undo and
 a maximum redo limit (e.g. max. 50 undo / 30 redo commands).
 The KCommandHistory keeps track of the "borders" and deletes
 commands, if appropriate. It also activates/deactivates the
 undo/redo actions in the menu and changes the text according
 to the name of the command.
 
 See {@link KCommandHistorySignals} for signals emitted by KCommandHistory.

 See {@link KCommandHistoryEventHandling} for event handlers to override in subclasses of KCommandHistory.

 @short 
 The command history stores a (user) configurable amount of
 Commands.
*/
public class KCommandHistory extends QObject  {
	protected KCommandHistory(Class dummy){super((Class) null);}


/** 
 Create a command history, to store commands.
 This constructor doesn't create actions, so you need to call
 {@link undo} and {@link redo} yourself.
     
*/
	private native void newKCommandHistory();
	public KCommandHistory() {
		super((Class) null);
		newKCommandHistory();
	}

/** 
 Create a command history, to store commands.
 This also creates an undo and a redo action, in the <code>actionCollection</code>,
 using the standard names ("edit_undo" and "edit_redo").

*/
	private native void newKCommandHistory( KActionCollection actionCollection, boolean withMenus);
	public KCommandHistory( KActionCollection actionCollection, boolean withMenus) {
		super((Class) null);
		newKCommandHistory( actionCollection, withMenus);
	}
	private native void newKCommandHistory( KActionCollection actionCollection);
	public KCommandHistory( KActionCollection actionCollection) {
		super((Class) null);
		newKCommandHistory( actionCollection);
	}
	protected native void finalize() throws InternalError;

/** 
 Erase all the undo/redo history.
 Use this when reloading the data, for instance, since this invalidates
 all the commands.
     
*/
	public native void clear();

/** 
 Adds a command to the history. Call this for each <code>command</code> you create.
 Unless you set <code>execute</code> to false, this will also execute the command.
 This means, most of the application's code will look like
    MyCommand  cmd = new MyCommand(i18n("The name"), parameters);
    m_historyCommand.addCommand( cmd );
     
*/
	public native void addCommand( KCommand command, boolean execute);
	public native void addCommand( KCommand command);

/** 

*/
	public native int undoLimit();

/** 
 Set the maximum number of items in the undo history
     
*/
	public native void setUndoLimit( int limit);

/** 

*/
	public native int redoLimit();

/** 
 Set the maximum number of items in the redo history
     
*/
	public native void setRedoLimit( int limit);

/** 
 Undo the last action.
 Call this if you don't use the builtin KActions.
     
*/
	public native void undo();

/** 
 Redo the last undone action.
 Call this if you don't use the builtin KActions.
     
*/
	public native void redo();

/** 
 Remember when you saved the document.
 Call this right after saving the document. As soon as
 the history reaches the current index again (via some
 undo/redo operations) it will emit {@link documentRestored}
 If you implemented undo/redo properly the document is
 the same you saved before.
     
*/
	public native void documentSaved();
	protected native void slotUndoAboutToShow();
	protected native void slotUndoActivated( int arg1);
	protected native void slotRedoAboutToShow();
	protected native void slotRedoActivated( int arg1);
}
