/***************************************************************************
                            KButtonBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Container widget for buttons. 

 This class uses Qt layout control to place the buttons; can handle
 both vertical and horizontal button placement.  The default border
 is now <code>0</code> (making it easier to deal with layouts). The space
 between buttons is now more Motif compliant.

 See {@link KButtonBoxSignals} for signals emitted by KButtonBox.

 See {@link KButtonBoxEventHandling} for event handlers to override in subclasses of KButtonBox.

 @author Mario Weilguni <mweilguni@sime.com>

 @version $Id: KButtonBox.java,v 1.2.2.2 2001/09/03 02:20:46 rdale Exp $

 @short 
 Container widget for buttons.
*/
public class KButtonBox extends QWidget  {
	protected KButtonBox(Class dummy){super((Class) null);}


/** 
 Create an empty container for buttons.

 If <code>_orientation</code> is <code>Vertical</code>, the buttons inserted with 
 {@link #addButton} are laid out from top to bottom, otherwise they 
 are laid out from left to right.
    
*/
	private native void newKButtonBox( QWidget parent, int _orientation, int border, int _autoborder);
	public KButtonBox( QWidget parent, int _orientation, int border, int _autoborder) {
		super((Class) null);
		newKButtonBox( parent, _orientation, border, _autoborder);
	}
	private native void newKButtonBox( QWidget parent);
	public KButtonBox( QWidget parent) {
		super((Class) null);
		newKButtonBox( parent);
	}

/** 
 Free private data field
    
*/
	protected native void finalize() throws InternalError;

/** 

 This size is
 calculated by the width/height of all buttons plus border/autoborder.
    
*/
	public native QSize sizeHint();

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, boolean noexpand);
	public native QPushButton addButton( String text);

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, QObject receiver, String slot, boolean noexpand);
	public native QPushButton addButton( String text, QObject receiver, String slot);

/** 
 Add a stretch to the buttonbox. 

 Can be used to separate buttons.  That is, if you add the
 buttons OK and Cancel, add a stretch, and then add the button Help,
 the buttons OK and Cancel will be left-aligned (or top-aligned
 for vertical) whereas Help will be right-aligned (or
 bottom-aligned for vertical).

    * @see QBoxLayout */
	public native void addStretch(int scale);
	public native void addStretch();

/** This function must be called <em>once</em> after all buttons have been
 inserted.

 It will start layout control.
    
*/
	public native QLayout layout();

/** 

*/
	protected native QSize bestButtonSize();
	protected native void placeButtons();
	protected native QSize buttonSizeHint( QPushButton arg1);
}
